optimum number of rules in the model has been determined by evaluating models with between one and ten fuzzy rules. The optimum number of rules is found to be four as it gives a low prediction error together with a small standard deviation. The remaining parameters of the neuro-fuzzy model are optimised using a combination of the least squares and gradient descent methods. 

## Threshold Determination

For a given input set, the neuro-fuzzy model gives an output of three decision values 
[x, y, z]. A correct classification must give the correct values of x, y and z i.e. it must correctly predict all the faults in one cylinder. The neuro-fuzzy model gives ouput values in the range [0, 1], and it is expected that the decision point will be around the halfway mark i.e. 0.5. In this experiment, two separate methods of determining the output have been tested. One simply assumes a decision point of 0.5 and the other method finds a decision point which minimises the error on the training set of 167. Individual thresholds are evaluated for each of three fault areas on the cylindrical shell. The selected threshold is the one that yields the maximum accuracy as defined by: 

$$A c c=p o s\cdot t p r+n e g\cdot(1-f p r)={\frac{t p r+c(1-f p r)}{c+1}}$$

Where tpr is the true positive rate, also known as the sensitivity given by: 

$$\left(7\right)$$
$\text{resistivity given by:}$
$\eqref{eq:walpha}$. 
tpr = TP /(TP + FN) **(8)** 
In Eq 7, fpr is defined as the false positive rate also known as the specificity given by: 
fpr = FP/(FP +TN) **(9)** 
TP, FN, FP and TN are all obtained from a confusion matrix and are defined as true positive, false negative, false positive and true negative, respectively. Parameter c **is the** 
relative importance of negatives to positives. In this study the fault cases and non-fault cases have been given equal importance in classification, meaning c **has been assigned a** 
value of 1. The results obtained from using both the threshold selection techniques are given in the next section. It should be noted that a correct classification is one in which the classifier correctly predicts the condition of all the three substructures of the cylinder. 

## Generalisation Performance

One of the problems experienced in machine learning is the assessment of the generalisation capabilities of a model. The K**-fold cross-validation method has been** 
shown to be an improved measure of performance over the holdout method, which divides the dataset into training and testing set [8]. With K**-fold cross-validation, the** dataset is divided into K **approximately equal sets. The holdout method is then performed** 
K times, where each time one of the unique K **sets are held back as a testing set and the** 
model is optimised using the combined, remaining K**-1 sets. The generalisation estimate** is then the average error of the model over all the K **sets. Leave-one-out cross-validation** is K-fold cross validation taken to its extreme. In this case K is equal to N**, the number of** 
instances in the given dataset. The cross-validation technique, though computationally 