# On-Line Condition Monitoring Using Computational Intelligence

C.B. VILAKAZI, T. MARWALA, P. MAUTLA and E. MOLOTO 
School of Electrical and Information Engineering University of the Witwatersrand Private Bag 3, Wits, 2050 SOUTH AFRICA 
t.marwala@ee.wits.ac.za Abstract:- **This paper presents bushing condition monitoring frameworks that use multi-layer perceptrons** 
(MLP), radial basis functions (RBF) and support vector machines (SVM) classifiers. The first level of the framework determines if the bushing is faulty or not while the second level determines the type of fault. The diagnostic gases in the bushings are analyzed using the dissolve gas analysis. MLP gives superior performance in terms of accuracy and training time than SVM and RBF. In addition, an on-line bushing condition monitoring approach, which is able to adapt to newly acquired data are introduced. This approach is able to accommodate new classes that are introduced by incoming data and is implemented using an incremental learning algorithm that uses MLP. The testing results improved from 67.5% to 95.8% as new data were introduced and the testing results improved from 60% to 95.3% as new conditions were introduced. On average the confidence value of the framework on its decision was 0.92. 

Key-Words: - **Dissolve gas analysis (DGA), multi-layer perceptrons (MLP), radial basis function (RBF),** support vector machines (SVM), Learn++ 
6 Introduction Bushings are important components in transmission and distribution of electricity. The reliability of bushings affects the availability of electricity in an area as well as the economical operation of the area. Transformer failure studies show that bushings are among the top three most common causes of transformer failure [1][2]. Bushing failure is usually followed by a catastrophic event such as tank rupture, violent explosion of the bushing and fire [2]. In such eventuality the major concern is the risk of collateral damage and personnel injury. 

 Various diagnostic tools exist such as on-line partial discharge (PD) analysis, on-line power factor, and infrared scanning to detect an impending transformer failure [3]. However, few of these methods can in isolation provide all of the information that a transformer operator requires to decide upon a cause of action. Computational intelligence methods can be used in conjunction with the above-mentioned methods for bushing condition monitoring. Condition monitoring has a number of important benefits such as; an unexpected failure can be avoided through the possession of quality information relating to on-line condition of the plant and the consequent ability to identify faults while in incipient levels of development. In this paper, methods that are based on computational intelligence techniques are developed and then used for interpreting data from dissolve gas-in-oil analysis
(DGA) test. The methods use machine learning classifiers multi-layer perceptrons (MLP), radial basis functions (RBF) and support vector machines (SVM). 

These methods are compared and the most effective method is implemented within the on-line framework. The justification for an on-line implementation is based on the fact that training data become available in small batches and that some new conditions only appear in subsequent data collection stage and therefore there is a need to update the classifier in an incremental fashion without compromising on the classification performance of the previous data.

7 Background This section gives a background on dissolve gas analysis, artificial neural networks and support vector machines. 

## 7.1 Dissolve Gas Analysis (Dga)

DGA is the most commonly used diagnostic technique for transformers and bushings [4][5]. DGA is used to detect oil breakdown, moisture presence and PD activity. Fault gases are produced by degradation of transformer and bushing oil and solid insulation such as paper and pressboard, which are all made of cellulose [6]. The gases produced from the 1