
## 7.2.2 Radial Basis Function

RBFs are type feed-forward neural networks employing a hidden layer of radial units and an output layer of linear units [10]. In RBF, the distance between the input vector and output vector determines the activation function [10]. RBF have their roots in techniques of performing exact interpolation of a set of data points in a multi-dimensional space. This interpolation requires that every input target be mapped exactly onto corresponding target vector. Fig.2 shows the architecture of RBF with four input layer neurons, five hidden layer neurons and two output layer neurons. 

![0_image_0.png](0_image_0.png)

The RBF network can be mathematically described as follows [10]: 

$$f_{k}(x)=\sum_{j=0}^{n}w_{kj}\phi_{j}(x)+b_{k}\tag{3}$$

![0_image_1.png](0_image_1.png)

where fk **represents the k-th output layer transfer** 
function, w and b **represents the weights and biases,** 
and φ j represents the j-th input layer transfer function represented in this paper by: 

field in this paper by.  $$\phi_{j}(x)=\exp\left(-\frac{\left\|x-\mu_{j}\right\|^{2}}{2\sigma_{j}^{2}}\right)\tag{4}$$

Here x represents the input, µ **represents the fixed** 
centre position and σ **represents fixed variance. RBF** 
consists of two stage training technique, in the first stage the input data are used to determine the parameters of the basis function. The basis functions are kept fixed while the second-layer weights are found in the second level of training. The second level training is explained in the next section. 

In the first stage, the input data are used to determine the centre and variance of the basis functions. A randomly selected subset of the input training data set is selected for use as the basis centres. Clusters of training data are then identified and a basis function is centred at each cluster. **The** 
parameter µ **is then chosen to be maximum distance** 
between the basis function centres. In the second stage of training, the basis functions are kept fixed and the output layer weight is modified and this is equivalent to a single-layer neural network. 

## 7.3 Support Vector Machines

SVM is a learning approach that implements the principle of Structural Risk Minimization (SRM). 

Structural risk minimization principle has been observed to be superior to the empirical risk minimization principle used in conventional neural networks [12]. SVM was developed to solve classification problems [12] and is schematically represented in Fig. 3. The idea behind SVM is to map an input space, x into a higher dimensional feature space, z. The goal is to find a kernel function ( f (x) ) that will map the input space to the training inputs to training outputs. Various feature spaces are used such as polynomial, Gaussian, Fourier series, splines as well as RBF and MLP nested within the activation function [13]. 

The classification inner activation function is given by [13]: 

$$f(x)=\sum_{i=1}^{m}\left(\alpha-\alpha_{i}\right).k\left(x_{i}\right)\tag{5}$$  $k(x_{i})$ is the kernel function and $\alpha_{i}$, $\alpha_{i}^{*}$ are the 
Here*, k(x*i) **is the kernel function and** αi, αj Langrage multipliers. The hyperplane that optimally separates the data are derived by minimizing the 