# The Road To Quantum Artificial Intelligence Kyriakos N. Sgarbas

Wire Communications Lab., Dept. of Electrical and Computer Engineering, University of Patras, GR-26500, Patras, Greece E-mail: sgarbas@upatras.gr 

## Abstract

This paper overviews the basic principles and recent advances in the emerging field of Quantum Computation (QC), highlighting its potential application to Artificial Intelligence (AI). The paper provides a very brief introduction to basic QC issues like quantum registers, quantum gates and quantum algorithms and then it presents references, ideas and research guidelines on how QC can be used to deal with some basic AI problems, such as search and pattern matching, as soon as quantum computers become widely available. Keywords: Quantum Computation, Artificial Intelligence 

## 1. Introduction

Quantum Computation (QC) is the scientific field that studies how the quantum behavior of certain subatomic particles (i.e. photons, electrons, etc.) can be used to perform computation and eventually large scale information processing. 

Superposition and *entanglement* are two key-phenomena in the quantum domain that provide a much more efficient way to perform certain kinds of computations than classical algorithmic methods. In QC information is stored in *quantum registers* composed of series of *quantum bits* (or *qubits*). QC defines a set of operators called quantum gates that operate on quantum registers performing simple qubit-range computations. *Quantum algorithms* are successive applications of several quantum gates on a quantum register and perform more elaborate computations. 

QC's ability to perform parallel information processing and rapid search over unordered sets of data promises significant advances to the whole scientific field of information processing. This article focuses on the benefits QC has to offer in the area of Artificial Intelligence (AI). In fact, several research papers have already reported how QC relates to specific aspects of AI (e.g. quantum game theory [Miakisz et al. (2006)], quantum evolutionary programming [Rylander et al. (2001)], etc). The present article attempts a more global view on quantum methods for AI applications addressing not only work already done but also some broad ideas for future work. But first it presents a very brief (due to space limitation) introduction to QC basics and algorithms, just the essentials to understand the subject. For a full introduction and 