quantum register remain in superposition until they are measured (intentionally or not). At the time of measurement the state of the register *collapses* (or *is resolved*) to one of its basis states randomly, according to the probability assigned to that state. It is not necessary to measure every single qubit of a quantum register in order to trigger its collapse to a basis state. For example, consider this case: 

$$\left|Q_{s}\right\rangle=\frac{1}{\sqrt{3}}\left|00000\right\rangle+\frac{1}{\sqrt{3}}\left|10000\right\rangle+\frac{1}{\sqrt{3}}\left|11111\right\rangle\tag{4}$$

Equation 4 specifies a 5-qubit register in superposition of three (of the 32 possible) basis states, |00000>, |10000> and |11111> with equal probability amplitudes; each of the three states has a 33% chance to be observed. Now, suppose we measure the qubits one by one starting from the leftmost. The leftmost qubit has a 67% chance to be |1> and 33% to be |0>. Let's say we measure it and find a |0>. We say that the leftmost qubit has collapsed to |0>. But it is not the only qubit that has collapsed; the rest four qubits must be all |0> too, since these are the only states consistent with the leftmost |0>. We say that the four rightmost qubits are *entangled* with the leftmost one. In other words, they are linked together in a way that each of the qubits loses its individuality. Measurement of one affects the others as long as they remain entangled together. Note that if instead of measuring the leftmost qubit we had decided to measure the rightmost one and found it |0>, three other qubits would collapse to |0> as well, but the leftmost qubit would still remain in superposition. But this does not mean that it was not affected by the measurement; it now has a 50%-50% chance of being observed in |0> or |1> instead of the initial 33%-67%. 

Superposition does not always imply entanglement. For example, consider the state of Eq.2: we have to measure each and every one of the n qubits in order to determine the exact state of the register. In this case there is no entanglement. 

Quantum systems in superposition or entangled states are said to be *coherent*. This is a very fragile condition and can be easily disturbed by interaction with the environment (which is considered an act of measurement). Such an accidental disturbance is called *decoherence* and results to losing information to the environment. Keeping a quantum register coherent is very difficult, especially if its size is large. 

## 3. Quantum Computation Components And Algorithms

Higher order quantum computation machines can be devised based on quantum registers: for instance quantum finite state automata can be produced by extending probabilistic finite-state automata in the quantum domain. Analogous extensions can be performed for other similar state machines (e.g. quantum cellular automata, quantum Turing machines, etc) [Gruska (1999)]. Regardless the machine, the 