computation is eventually reduced to a series of basic operations to some qubits of a quantum register; this is what *quantum gates* do. 

Quantum gates are the basic computation components for QC. They are very different from gates in classical computation systems. Quantum gates are not circuits with input and output; they are operators over a quantum register. These operators are always reversible; most of them originate from reversible computation theory. An infinite number of quantum gates can be defined (even for a single qubit) since it is possible to define an operator that rotates an arbitrary quantum register state anywhere in the Hilbert space. The most common quantum gates are: 
- *The Identity Gate:* It is the quantum equivalent of a buffer. - *The NOT Gate:* It is used to complement the input. 

- *The Hadamard Gate:* It is used to set a qubit in a superposition of two states. 

Acts on a single qubit. 

- *The Phase Shift Gate:* In fact it is a class of gates with varying phases. It changes the phase of a qubit in the Hilbert space. 

- *The Controlled NOT Gate (CNOT or XOR):* Like the NOT gate, but acts on two qubits. The first one is called *control qubit*, the second one *target*. The gate performs a complement of the target qubit only if the control qubit is |1>. 

This effect is equivalent to a XOR operation between the two qubits, hence the alternative name. 

- *The Controlled Phase Shift Gate:* Like the Phase Shift gate, but acts on two qubits: control and target. It performs a phase shift on the target qubit only if the control qubit is |1>. 

- *The Exchange Gate:* Acts on two qubits and exchanges their values. 

- *The Controlled-Controlled NOT Gate (CCNOT or Toffoli):* Like the CNOT, 
but with two control qubits. Both of them should be |1> in order to complement the target qubit. 

- *The Fredkin Gate:* Like the Exchange gate, with an additional control qubit. 

The two target qubits exchange their values only if the control qubit is |1>. 

Each gate is expressed as a matrix, so that the application of a quantum gate on the contents of a quantum register is expressed as a matrix multiplication. Quantum Algorithms are series of applications of quantum gates over the contents of a quantum register. The most popular quantum algorithms are: 
- *Parallel Computation:* Thought not exactly an algorithm, the intrinsic property of quantum registers to support massively parallel computation is mentioned due to its use in almost every quantum algorithm. When a transformation is performed to the contents of a quantum register this affects the whole set of its superimposed values. Reading the outcome is a nondeterministic process, but it is possible to maximize the probability to occur 