Grover's algorithm [Grover (1997)] and its variations are ideal for efficient contentaddressable search and information retrieval from large collections of raw data. The principle of *probability amplitude amplification* that guides these processes can be relaxed for approximate pattern matching as well, thus facilitating applications like face, fingerprint, and voice recognition, corpus search, and data-mining. A quantum register containing a set of data in superposition can be seen as the quantum analog of a Hopfield neural network used as an associative memory [Trugenberger (2002)] only with much greater capacity to store patterns: while the capacity of a n-neuron Hopfield network approximates to 0.14n patterns, a quantum register of n-qubits can store 2n binary patterns. 

In principle, a great deal of the problems that AI attempts to confront is too heavy for classical algorithmic approaches, i.e. NP-hard problems such as scheduling, search, etc. Many AI techniques have been developed to cope with the NP-complete nature of these problems. Since QC can reduce time complexity to polynomial range, it eventually provides a more efficient way to address these problems. Using QC all the states of the search space can be first superimposed on a quantum register and then a search can be performed using a variance of Grover's algorithm. It is evident that many problems in search, planning, scheduling, game-playing, and other analogous fields can utilize the parallel processing of a quantum register's contents and reduce their processing times by several orders of magnitude. For more complex problems even quantum constraint satisfaction heuristics can be applied, as described in [Aoun & Tarifi (2004)]. But the main challenge in these cases is to find a way to encode the problem space within the quantum register boundaries. Fortunately, for problems where a previous approach based on genetic algorithms is available, there is a significant basis for QC as well: the representation of the gene-string can be transferred to the quantum implementation almost verbatim and the whole gene pool can be superimposed to a single quantum register. Speech and language processing have also a great deal to gain from QC. Apart from the aforementioned approximate pattern matching to the input signal and the obvious rapid quantum search in huge lexical databases, the representation problem can be solved quite elegantly in a quantum register and more efficiently than ever. For instance, a common drawback of a typical syntactic parser is the fact that it produces too many parse trees, some slightly different and some quite different ones. Their representation as superimposed states in a quantum register solves not only the issue of their storage, but simplifies their further processing as well. An interesting model for the mapping of language expressions into microscopic physical states has been proposed by [Benioff (2002)]. Game theory and decision-making have also been addressed by QC. A new field of quantum game theory has emerged [Piotrowski & Sladkowski (2004a)] with promising applications at least to playing market games [Piotrowski & Sladkowski (2004b)]. The entanglement effect has been exploited to improve behavior in 