# Truecluster Matching

Jens Oehlschl¨agel jens.oehlschlaegel@truecluster.com

## Editor: Abstract

Cluster matching by permuting cluster labels is important in many clustering contexts such as cluster validation and cluster ensemble techniques. The classic approach is to minimize the euclidean distance between two cluster solutions which induces inappropriate stability in certain settings. Therefore, we present the *truematch* algorithm that introduces two improvements best explained in the crisp case. First, instead of maximizing the trace of the cluster crosstable, we propose to maximize a χ 2-transformation of this crosstable. Thus, the trace will not be dominated by the cells with the largest counts but by the cells with the most non-random observations, taking into account the marginals. Second, we suggest a probabilistic component in order to break ties and to make the matching algorithm truly random on random data. The truematch algorithm is designed as a building block of the truecluster framework and scales in polynomial time. First simulation results confirm that the truematch algorithm gives more consistent truecluster results for unequal cluster sizes.

Free R software is available. Keywords: Hungarian method, truematch, truecluster, MMCC, CIC, Hornik (2005)

## 1. Introduction

Applying a cluster algorithm to a dataset results in—fuzzy or crisp—assignments of cases to anonymous clusters. In order to interpret these clusters, we often wish to compare these clusters to other classifications, so some heuristic is needed to match one classification to another. With the advent of resampling and ensemble methods in clustering (Gordon and Vichi, 2001; Dimitriadou et al., 2002; Strehl and Ghosh, 2002), the task of matching cluster solutions has become even more important: we need reliable and scalable matching algorithms that do the task fully automated.

Consider, for example, the use of bootstrapping or cross-validation for cluster validation as suggested by many authors (Moreau and Jain, 1987; Jain and Moreau, 1988; Tibshirani et al., 2001; Roth et al., 2002; Ben-Hur et al., 2002; Dudoit and Fridlyand, 2002): many cluster solutions are created and agreement between them is evaluated. Some agreement indices do not need explicit cluster matching (Rand, 1971; Hubert and Arabie, 1985), but others can only be applied *after* cluster solutions have been matched, for example, Cohen's kappa (1960).

Recently, authors have suggested transfering the idea of bagging (Breiman, 1996) to clustering. Some approaches aggregate cluster centers (Leisch, 1999; Dolnicar and Leisch, 2000; Bakker and Heskes, 2001) or aggregate consensus between pairs of observations (Monti et al., 2003; Dudoit and Fridlyand, 2003, *BagClust2* algorithm). Other approaches aggregate cluster assignments and, therefore, require cluster matching, for example, the crisp arXiv:0705.4302v1 [cs.AI] 29 May 2007