
## 6. Discussion

We have shown that trace maximization matching fails to behave sufficiently neutrally when matching clusterings. The problem arises generally but is especially important in contexts where random correction is not applicable. As an alternative, we have presented the truematch algorithm and heuristic, both probabilistically generate neutral expected matching tables and scale in polynomial time. Our simulations have confirmed that truematch avoids unjustified (expected) matchings induced by unequal cluster sizes. For the simulations done here, the truematch algorithm and the truematch heuristic behave identically. Since the truematch heuristic does not guarantee maximizing the χ 2-criterion, we expect the truematch algorithm to be superior. However, there is a subtle difference: while the matching of the truematch algorithm depends solely on sk,l, the truematch heuristic uses sk,l and nk,l to select the row/column matches. Therefore, a final decision about an optimal matching algorithm needs more investigation.

Truematch is central to the *MMCC* algorithm, which creates the basis for the CICevaluation in the truecluster framework and, thus, contributes to solving the decade-old problem of choosing the optimal number of clusters. Beyond that, cluster bagging, in general, could benefit from using truematch: the resulting N x K matrix is rather fuzzified than degenerated for unjustified cluster splits. This allows for better automated processing of such results. It is an open question whether the truematch algorithm also has advantages for consensus clustering, or whether different usages of cluster ensembles require different matching algorithms.

## Acknowledgments

We would like to thank Dr. Stefan Pilz for reviewing this paper and giving valuable hints for improvement.