
## Appendix A.

In this appendix, we give details concerning the simulations in section 5: assume a vector x of length 100 with 'true' sample group memberships where p denotes the fraction of 1 and
(1 − p) fraction of 0. Let p1 denote the matrix of joint probabilities for a case's true and clustered classification when the cluster algorithm perfectly separates 0 from 1 (at κ = 1).

$$\mathbf{p}_{1}={\left|\begin{array}{l l}{(1-p)}&{0}\\ {0}&{p}\end{array}\right|}$$

Let p0 denote the matrix of joint probabilities for a case's true and clustered classification when the cluster algorithm makes a random guess when separating 0 from 1 (at κ = 0).

$$\mathbf{p}_{0}={\left|\begin{array}{l l}{(1-p)^{2}}&{(1-p)\cdot p}\\ {(1-p)\cdot p}&{p^{2}}\end{array}\right|}$$

Then pκ denotes the matrix of joint probabilities for a case's true and clustered classification when the cluster algorithm has reliability κ.

$$p_{\kappa}=\kappa\cdot\mathbf{p}_{1}+(1-\kappa)\cdot\mathbf{p}_{0}$$

The two conditional probabilites pid that the clustering algorithm identifies the true class, given the true class, are

$$\mathbf{p}_{i d}=\kappa+(1-\kappa)\cdot{\left|\begin{array}{l}{(1-p)}\\ {p}\end{array}\right|}$$

For each value of p ∈ {1/100, 2/100..99/100} and each value of κ ∈ {0.00, 0.01, 0.02*, ..,* 1.00},
we simulate aggregation of 1000 bootstrap samples from x, for each bootstrap sample our fictitious cluster algorithm assigns cases with probability pid to the true class and with probability 1 − pid to the other class. The resulting cluster memberships c
∗ are matched versus the (current) estimated cluster memberships ˆc of the cases in the bootstrap sample.

If c
∗ or ˆc does not contain two classes, the bootstrap sample is dropped and replaced by another one. Differently from the *MMCC* algorithm in Section 4, we do not predict cluster memberships of the out-of-bag cases. We use c
∗ directly instead of c 0, consequently the rows of C are not guaranteed to have aggregated an equal number of votes. For all combinations of p and κ—the resulting 99x101 truecluster models Pˆ—we calculate information, *uncertainty*, and CIC (Oehlschl¨agel, 2007b). These values are visualized using colorcoding and contourlines are added based on a loess smooth. To create the *f ixed* version, the complete procedure is repeated, additionally enforcing a fixed fraction p by moving randomly selected observations in c
∗from the too big group to the too small one—analogous to a cluster algorithm that forces certain cluster sizes. The R-code doing the simulation is available in truematch.r in package truecluster (Oehlschl¨agel, 2007a).