
## 5. Simulation Results

In order to systematically investigate the consequences of the different features of truematch versus simple trace maximization matching, we have carried out extensive simulations within the truecluster framework: we assume two clusters and vary their relative size p and the reliability κ of a fictitious clustering algorithm and compare the *truecluster* results gained via trace maximization versus truematch. We did two versions of the simulations: in the non-fixed version, p just determines sampling probabilitites; in the *fixed* version, the fictitious clustering algorithm enforces the exact relative size p of the two clusters. Details of the simulation are given in Appendix A.

Figure 1 shows information, *uncertainty*, and its difference CIC for the non-fixed simulations. White areas denote simulation trials where the truecluster algorithm degenerated from a 2-cluster solution to a 1-cluster solution. The most notable difference is the big share of non-converged truecluster solutions using trace maximization, compared to the truematch algorithm. The estimated information, given reliability and skewness, is very similar and reasonable: information is highest for p = 0.5 and κ = 1.0 and is lower for both reducing κ and/or skewing p.

By contrast, compared for uncertainty and for the CIC, trace maximization and truematch differ dramatically. Using trace maximization, the uncertainty estimate does not only depend on κ but is also artificially lower for higher skewness. As a consequence, cluster models with unequal cluster sizes get better CIC values than cluster models with equal cluster sizes. Using the truematch algorithm almost avoids this undesirable pattern: the estimated uncertainty almost only depends on κ, not on p. The estimated CIC shows a very reasonable pattern: at high κ the CIC is highest for equal sized clusters—conforming with the entropy principle— at low κ, the CIC is low, however skewed p is. Only at very extreme p is the CIC biased downwards: too small clusters cannot be detected with too small a sample size. Extreme models are non-identifiable and the uncertainty estimate has high variance. Keep in mind that 'extreme' p corresponds to very few cases at a sample size of N = 100. The fixed simulations gave similar results (Figure 2).

In summary, trace maximization fails to estimate uncertainty independent of skewness and tends to overestimate CIC for unequal cluster sizes or fails to converge. This restricts its usefulness for cluster evaluation and bagging. By contrast, the truematch algorithm works at almost any combination of reliability and skewness (with the exception of nonidentifiable models, given the sample size).