# Modeling Computations In A Semantic Network

Marko A. Rodriguez and Johan Bollen Digital Library Research and Prototyping Team Los Alamos National Laboratory Los Alamos, New Mexico 87545
(Dated: August 24, 2021)
Semantic network research has seen a resurgence from its early history in the cognitive sciences with the inception of the Semantic Web initiative. The Semantic Web effort has brought forth an array of technologies that support the encoding, storage, and querying of the semantic network data structure at the world stage. Currently, the popular conception of the Semantic Web is that of a data modeling medium where real and conceptual entities are related in semantically meaningful ways. However, new models have emerged that explicitly encode procedural information within the semantic network substrate. With these new technologies, the Semantic Web has evolved from a data modeling medium to a computational medium. This article provides a classification of existing computational modeling efforts and the requirements of supporting technologies that will aid in the further growth of this burgeoning domain.

keywords: I.2.12 Intelligent Web Services and Semantic Web - I.2.4.k Semantic networks - I.2.4 Knowledge Representation Formalisms and Methods - I.2 Artificial Intelligence - I Computing Methodologies

## I. Introduction

A semantic network is generally defined by a directed labeled graph [18]. Formally, a directed labeled graph can be represented in set theoretic notation as G = (*V, E* ⊆ V × *V, λ* : E → Σ), where V is the set of vertices, E is the set of edges, and λ is a function that maps the edges in E to the set of labels in Σ. Another perspective would organize each label type according to its own edge group and in such cases, G = (V, E = {E0, E1*, . . . , E*n}), where E is the set of all labeled edge sets, Ei ∈ E is a particular labeled edge set, and Ei ⊆ V × V [3].

For the Semantic Web, the semantic network substrate is defined by the constraints of the Resource Description Framework (RDF) [7, 12]. RDF represents a semantic network as a set of triples where both vertices and edge labels are called resources. In RDF, a subject resource (s) points to an object resource (o) according to a predicate resource (p). Subject and predicate resources are identified by Uniform Resource Identifiers (URI) [21] and the object is either a literal or a URI. If U is the set of all URIs and L is the set of all literals, then the Semantic Web can be formally defined as G ⊆ (U × U × (U ∪ L)).

This representation is called a triple list where a triple τ = h*s, p, o*i. RDF is a framework (or model) for denoting a semantic network in terms of URIs and literals.

RDF is not tied to a particular syntax. Various RDF
syntaxes have been developed to support the encoding and distribution of RDF graphs [1].

Ontology languages have been developed to constrain the topological features of the Semantic Web. The Resource Description Framework Schema (RDFS) supports the representation of subclassing, instantiation, and domain/range restrictions on predicates [12]. The Web Ontology Language (OWL) was developed after RDFS and allows for the creation of more advanced ontologies [13].

In OWL, cardinality restrictions, unions, and ontology dependencies were introduced. Semantic Web ontology languages, interestingly, are represented in RDF. Thus, G is the set of all ontologies and their instances.

With RDF, RDFS, and OWL, a medium currently exists to model any physical or conceptual entity and their relationships to one another. The Semantic Web supports universal modeling and allows for the commingling of disparate heterogeneous models within a single substrate that can be used by humans and machines for any computational end. Any statement, logical or illogical, true or false, possible or impossible, can be made explicit in the Semantic Web. While the Semantic Web is primarily used to define descriptive models, there is nothing that prevents the representation of procedural models. In other words, models of computing can be explicitly represented in G. It is this modeling power that has prompted the growth of the semantic computing paradigm where the Semantic Web is no longer perceived solely as a universal data modeling medium, but also as a universal computing platform.

While the ideas presented in this article are amenable to any semantic network representation, this article will focus primarily on the Semantic Web due in large part to the technological infrastructure that currently supports this effort. This article's exploration will begin with a review of the various aspects of G. Next, a formal definition of computing will be presented in order to describe how the various components of computing can be represented by a semantic network. Current semantic network computing models will be placed within this semantic computing space. The definition of this space will expose areas that have yet to be developed and leave open the potential for future work in the area of semantic network computing.