or right (rt) on D, and finally 3.) determine which state in Q to transition to at the next time step,. This 5-tuple model is a simplified version of the 7-tuple representation in [9].

Let M denote a Turing machine that increments a unary number by one. While this is not the most exciting algorithm, it is simple enough to represent succinctly and provides an example of the previous abstract concept. The δ-function for M is

![0_image_1.png](0_image_1.png)

where M will write a 1 if a 0 exists at its current d ∈ D,
else it will move right and replay state A and the state B
is considered the halt state. Thus, if D = (1, 1, 0, 0), M will read the first 1, move right, read the second 1, move right, read the first 0, and write a 1. Upon entering state B, D = (1, 1, 1, 0). At the completion of this algorithm, the number 2 (11) is incremented to 3 (111). M and D
are represented in Figure 2.

![0_image_2.png](0_image_2.png)

FIG. 2: A Turing machine uses the tape for its input and output.

Imagine having a single physical machine for every computation one required to execute. For instance, one would have an M to add integers, an M to divide floatingpoints, an M to compare a string of characters, etc. To meet modern computing requirements, an unimaginable number of machines would be required. However, in fact, a single machine does exist for each computing need! Fortunately, these machines need not be physically represented, but instead can be virtually represented in D. This is the concept of the stored program and was serendipitously discovered by Alan Turing when he developed the idea of the universal Turing machine [20].

## B. Modeling Computations Using A Universal Turing Machine

A universal Turing machine, M∗, is a Turing machine that can execute the behavior of another Turing machine, M. This idea is a central tenet to the engineering of modern day computers. With a universal Turing machine, the state behavior of M can be encoded on D such that some M∗can simulate the behavior of the M encoded in D. In such cases, there exists another portion of D that serves as the input/ouput to M denoted DM ⊂ D. This idea is depicted in Figure 3.

![0_image_0.png](0_image_0.png)

The benefit of M∗is that M∗is a general-purpose machine that can be used to execute any algorithm. Thus, there need not exist separate physical machines for each algorithm. However, in order for M∗to execute some M, M must be encoded such that it is congruent with the expectations of M∗'s δ-function. Thus, there exists an ontology, Mˆ , defining the requirements of the M encoding. If some M is represented according to Mˆ , then M∗can execute it. In the lexicon of modern computing, if a program is written in native machine code, then the native machine can execute it.

Finally, to present the conclusion of this chain of reasoning, it is possible for M∗to be encoded according to the Mˆ ontology. Let M∗ denote the physical machine and M∗1 ⊂ D denote the virtual D-encoded machine that is congruent with Mˆ . In such cases, M∗1can be used to execute some other M in DM∗1 ⊂ D. This idea is diagrammed in Figure 4. This idea is congruent with the concept of the virtual machine of modern day computing
[6].

![0_image_3.png](0_image_3.png)

## Iv. Representing Computations In A Semantic Network

While the Turing model of computing is very simple, it is actually quite representative of the current state of computing in semantic networks. The Semantic Web's G
is a data structure similar to D except that G is not a one-dimensional vector of Γ symbols. While it is possible to represent G as a one-dimensional string of Γ symbols, the more intuitive and useful representation is that of a network of URIs (U) and literals (L). G is a highlydistributed universal "tape" that can be accessed by machines world-wide for various computational purposes.