However, how much of G is leveraged for computing is machine-instance dependent.

Currently, the actual application that explicitly encodes subsets of G is the triple-store (i.e. graph database, semantic repository, etc.). A triple-store is a database that contains a subset of the larger Semantic Web. The triple-store is the gatekeeper for determining how triples are read from and written to the Semantic Web. Unlike the read/write head of the Turing machine, the machines that access G are able to move about G in a more random-access fashion due to the development of the common variable-binding interface. While any other G interface may be developed in the future, the lowestlevel requirements of such an interface are the ability to read, write, and delete triples from G. This section will discuss the nature of a primitive read/write interface into G and its relation to G-computing.

As demonstrated by Alan Turing, the most primitive components required for a computing machine are the ability to read and write to a medium and alter its states according to its perception of that medium. Similar to the relationship between M and D, it is possible to develop a semantic Turing machine that is able to read/write to G and evolve its state behavior accordingly.

A semantic Turing machine is denoted S and can be formalized by the 5-tuple

$$S=\langle Q,\Gamma,\delta,q_{0},X\rangle,$$

## Where - Q Is A Set Of Machine States,

- Γ ⊆ U ∪ L is the set of URI and literal symbols, - δ : Q × R(ϕ) × X → {W(τ ), E(ϕ)} × Q × Q is the transition/behavior function,
- q0 ∈ Q is the start state of the machine,
- and X is a set of random access machine heads.

These components will be discussed in full throughout the remainder of this section.

The most readily used low-level read model for the Semantic Web is the 3-element symbol binding model,

## R : Φ → Τ ∈ G,

where ϕ is called a query, ϕ = h*a, b, c*i, and the elements a, b, and c can either be drawn from the set Γ = U ∪ L or from the set of machine heads defined by X. If those heads in X are declared bindings, then the machine head is random access. In a semantic Turing machine, there does not exist an explicit move behavior. If a state q ∈ Q is to move a random access head, then it places a bind-symbol before the head name (e.g. ?x1) otherwise the machine will hold its head at its current pointed to location with a static-symbol
(e.g. !x1). For instance, R(hmarko, isA, ?x1i) would place the head ?x1 on some object of a triple with the subject marko and predicate isA. If ?x1 bound to human then τ = hmarko, isA, humani ∈ G. However, if the machine head is already at a particular resource in G, then it can be used as a static variable. If ?x1 bound to human on a previous read, then R(h!x1, subClassOf, ?x2i) will move
?x2 to the resource mammal. With the random-access X
machine heads, no variable states are represented internal to S, they are simply pointed to by some x ∈ X in G.

The most readily used write model for the Semantic Web is to union the semantic network triple list G with a new triple τ ,

$$W:\tau\to G\cup\tau,$$
——
where τ = h*s, p, o*i, s ∈ U, p ∈ U, and o ∈ (U ∪ L).

Finally, in order to erase (i.e. delete) a triple, the 3element symbol binding model can be used,

## E : Φ → G \ R(Φ),

where the triple R(ϕ) ∈ G is removed from G.

An S can be built to do any type of computation on G. The popular Horn-clause query/assertion can be represented by an S [10]. For instance, the rule

## Hasparent(Marko, ?X1) ∧ Hasbrother(?X1, ?X2) → Hasuncle(Marko, ?X2)

states that if marko has a parent that binds to ?x1 and x1 has a brother that binds to ?x2 then assert (i.e. write)
the fact that x2 is marko's uncle. The δ-function for S
that executes this query is

qi R X W E qi+1 6ϕ

![0_image_0.png](0_image_0.png)

![0_image_1.png](0_image_1.png)

A hmarko, hasParent, ?x1i ∅ ∅ ∅ B C
B h!x1, hasBrother, ?x2i ∅ hmarko, hasUncle, !x2i ∅ C C
C ∅ ∅ ∅ ∅ C ∅
where q0 = A, C is the halt state, x1, x2 ∈ X and 6ϕ is the state transition when a ϕ fails. If

## G ={Hmarko, Hasparent, Carolei, Hcarole, Hasbrother, Georgei},

then at q0 = A, ?x1 will point to carole, at q1 = B, ?x2 will point to george, and at q3 = C,

## G ={Hmarko, Hasparent, Carolei, Hcarole, Hasbrother, Georgei Hmarko, Hasuncle, Georgei}.

For more arithmetic operations and for the construction of novel URIs and literals, the classic Turing machine