two S
∗ machines encoded in G: S
∗1 and S
∗2, where S
∗1 ∩ S
∗2 = ∅. The external S
∗can be reading in S
∗1 as a program, which is reading in S
∗2 as a program, which is reading in some other machine S as a program. In this model, there is no limit to the amount of computing redirection that is possible. Ultimately, it is up to the external S
∗to perform all the read/write operations that update the respective states of all the chained together S
∗n machines.

In the virtual machine model, not only is procedural data encoded in G, but also machine data. There must exist both an ontology for procedural data Sˆ and an ontology for machine data Sˆ∗. In principle, any subset of G that obeys Sˆ∗ is a virtualized computing machine.

## D. True Universality

While a universal semantic Turing machine can be created, it is impractical to do so because of the speed constraints currently realized by the read/write interface to the Semantic Web and because any external S
∗ already exists in a substrate engineered for general-purpose computing. Therefore, for virtualized semantic machines, Dmediums are currently used for low-level arithmetic operations only. There will always be a tradeoff between the desire to represent low-level computations in G and the desire to ensure the fast execution of those G-based machine representations.

The Fhat processor was designed with this constraint in mind. Many aspects of the machine's state are represented in G including its operand stack, symbol table, program counter, etc. However, when a low-level operation such as add 2 3 is called, those values are calculated on the physical machine, not in G. While this may not be completely theoretically satisfying, it does support a practical implementation of the virtual machine model of computing in G.

## Vi. The Future Of Semantic Network Computing

The future of semantic network computing may be one in which virtual machines and their programs exist in G. Any universal machine external to G can gain access to the URI denoting a virtual machine and begin to execute its "physics". In other words, evolve its state and compute. In this idealized world, the underlying physical hardware supporting the execution of these virtual machines is more or less inconsequential. These underlying hardware processors are analogous to the underlying physics supporting the execution of our hardware machines. Once the protocols are in place to ensure that G has a farm of processors continuously evolving it, then the Semantic Web will have reached a transition to where abstract virtualized computing becomes ubiquitous and G can be seen as a single distributed computer with the massive address space of U ∪ L. However, there are still many obstacles that prevent this model from becoming a common reality.

First, the read/write speeds for G are orders of magnitude slower than the read/write speeds for local memory and thus, computing in G is orders of magnitude slower.

There is still much more room for growth in the area of triple-store index algorithms. Unlike the relational database model where data is broken into different linked tables, the triple-store is a single massive table with various indexes supporting fast searching. As the read/write speeds continue to increase, the ability to use G as a computing "tape" will become more viable.

Third, current triple-store's have limits on the number of triples they can feasibly represent in a single store.

While some stores can easily support up to 109triples, the explicit representation of procedural data reduces the amount of space available for descriptive data. Fortunately, with an increase in the use of standards liked Linked Data [4], the growth of G will have limited effect on the ability to compute in G.

Fourth, the current state of affairs in the Semantic Web is such that writing to G is cumbersome due to the absence of a generally accepted protocol to do so.

While the proposed SPARQL/Update protocol [16] is one such write interface, it is not widely supported by all triple-store providers. Thus, each triple-store provider maintains their own mechanism for writing and deleting triples.

Finally, there does not exist a universal trust and security mechanism to deter malicious machines in G. If G is conceived as a a universal computing "tape", then the read, and more importantly, write/delete accesses to G will need to be established. Of course, G is only contained in an abstract universal store. Each triple-store supports only a subset of the larger whole. Therefore, for those running a triple-store, read/write privileges is not an issue. However, as more procedural information is encoded in G and machines can share procedural fragments, understanding where particular bits of information were derived from becomes very important. Work in the area of named graphs for trust and provenance should prove promising in this area [5]. The named graph extends the triple concept by adding an extra resource called g, or graph. A triple is thus a quad and τ = h*s, p, o, g*i. The g component of τ is a URI and this information can be used to attach read/write privileges to particular subnetworks of G.

While this list is not conclusive, it provides an overview of some of the more prominent issues concerning the future of semantic network computing.

## Vii. Conclusion

Given that the Semantic Web is an abstract data structure, it does not have the capacity to perform a computation in and of itself. The Semantic Web is simply a 7