# Automatically Restructuring Practice Guidelines Using The Gem Dtd

Amanda Bouffier Thierry Poibeau Laboratoire d'Informatique de Paris-Nord Université Paris 13 and CNRS UMR 7030 99, av. J.-B. Clément - F-93430 Villetaneuse firstname.lastname@lipn.univ-paris13.fr 

## Abstract

This paper describes a system capable of semi-automatically filling an XML template from free texts in the clinical domain (practice guidelines). The XML template includes semantic information not explicitly encoded in the text (pairs of conditions and actions/recommendations). Therefore, there is a need to compute the exact scope of conditions over text sequences expressing the required actions. We present a system developed for this task. We show that it yields good performance when applied to the analysis of French practice guidelines. 

## 1 **Introduction**

During the past years, clinical practices have considerably evolved towards standardization and effectiveness. A major improvement is the development of practice guidelines (Brownson et al.**, 2003).** 
However, even if widely distributed to hospitals, doctors and other medical staff, clinical practice guidelines are not routinely fully exploited1**. There** 
is now a general tendency to transfer these guidelines to electronic devices (via an appropriate XML 
format). This transfer is justified by the assumption that electronic documents are easier to browse than paper documents. 

However, migrating a collection of texts to XML 
requires a lot of re-engineering. More precisely, it means analyzing the full set of textual documents so that they can fit with strict templates, as required either by XML schemas or DTD (document type definition). Unfortunately, most of the time, the 
 
1 **See (Kolata, 2004). This newspaper article is a good example** 
of the huge social impact of this research area. 

semantic blocks of information required by the XML model are not explicitly marked in the original text. These blocks of information correspond to discourse structures. 

This problem has thus renewed the interest for the recognition and management of discourse structures, especially for technical domains. In this study, we show how technical documents belonging to a certain domain (namely, clinical practice guidelines) can be semi-automatically structured using NLP techniques. Practice guidelines describe best practices with the aim of guiding decisions and criteria in specific areas of healthcare, as defined by an authoritative examination of current evidence 
(evidence-based medicine, see Wikipedia **or** 
Brownson et al.**, 2003).** 
The Guideline Elements Model (GEM) is an XML-based guideline document model that can store and organize the heterogeneous information contained in practice guidelines (Schiffman, 2000). 

It is intended to facilitate translation of natural language guideline documents into a format that can be processed by computers. The main element of GEM, knowledge component, **contains the most** 
useful information, especially sequences of conditions and recommendations. Our aim is thus to format these documents which have been written manually without any precise model, according to the GEM DTD (see annex A). 

The organization of the paper is as follows: first, we present the task and some previous approaches 
(section 2). We then describe the different processing steps (section 3) and the implementation (section 4). We finish with the presentation of some results (section 5), before the conclusion (section 6). 