
## 2 **Document Restructuring: The Case Of** Practice Guidelines

As we have previously seen, practice guidelines are not routinely fully exploited. One reason is that they are not easily accessible to doctors during consultation. Moreover, it can be difficult for the doctor to find relevant pieces of information from these guides, even if they are not very long. To overcome these problems, national health agencies try to promote the electronic distribution of these guidelines (so that a doctor could check recommendations directly from his computer). 

## 2.1 **Previous Work**

Several attempts have already been made to improve the use of practice guidelines: for example knowledge-based diagnostic aids can be derived from them (e.g. Séroussi et al., **2001).** 
GEM is an intermediate document model, between pure text (paper practice guidelines) and knowledge-based models like GLIF (Peleg **et al.**, 2000) or EON (Tu and Musen, 2001). GEM is thus an elegant solution, independent from any theory or formalisms, but compliant with other frameworks. 

GEM Cutter (http://gem.med.yale.edu/**) is a** 
tool aimed at aiding experts to fill the GEM DTD 
from texts. However, this software is only an interface allowing the end-user to perform the task through a time-consuming cut-and-paste process. The overall process described in Shiffman **et al.**
(2004) **is also largely manual, even if it is an attempt to automate and regularize the translation** 
process. 

The main problem in the automation of the translation process is to identify that a list of recommendations expressed over several sentences is under the scope of a specific condition (conditions may refer to a specific pathology, a specific kind of patients, temporal restrictions, etc.). However, previous approaches have been based on the analysis of isolated sentences. They do not compute the exact scope of conditional sequences (Georg and Jaulent, 2005): this part of the work still has to be done by hand. 

Our automatic approach relies on work done in the field of discourse processing. As we have seen in the introduction, the most important sequences of text to be tagged correspond to discourse structures (conditions, actions …). Although most researchers agree that a better understanding of text structure and text coherence could help extract knowledge, descriptive frameworks like the one developed by Halliday and Hasan2 **are poorly formalized and difficult to apply in practice.** 
Some recent works have proposed more operational descriptions of discourse structures (PéryWoodley, 1998). Several authors (Halliday and Matthiessen, 2004; Charolles, 2005) have investigated the use of non-lexical cues for discourse processing (e.g temporal adverbials like "**in 1999"**). These adverbials introduce situation frames in a narrative discourse, that is to say a 'period' in the text which is dependent from the adverbial. 

We show in this study that condition sequences play the same role in practice guidelines: their scope may run over several dependent clauses 
(more precisely, over a set of several recommendations). Our plan is to automatically recognize these using surface cues and processing rules. 

## 2.2 **Our Approach**

Our aim is to semi-automatically fill a GEM template from existing guidelines: the algorithm is fully automatic but the result needs to be validated by experts to yield adequate accuracy. Our system tries to compute the exact scope of conditional sequences. In this paper we apply it to the analysis of several French practice guidelines. 

The main aim of the approach is to go from a textual document to a GEM based document, as shown on Figure 1 (see also annex A). We focus on conditions (including temporal restrictions) and recommendations since these elements are of paramount importance for the task. They are especially difficult to deal with since they require to accurately compute the scope of conditions. 

The example on figure 1 is complex since it contains several levels of overlapping conditions. We observe a first opposition (Chez le sujet non immunodéprimé / chez le sujet immunodéprimé… Concerning the non-immuno-depressed patient / Concerning the immuno-depressed patient…**) but a second condition interferes in the scope of this first** 
level (En cas d'aspect normal de la muqueuse iléale… If the ileal mucus seems normal…**). The task** 
involves recognizing these various levels of conditions in the text and explicitly representing them through the GEM DTD. 