(especially connectors and lexical cues) can be automatically captured by machine learning methods. 

Material structure cues**. These features include the** recognition of titles, section, enumerations and paragraphs. 

Morpho-syntactic cues. **Recommendations are not** expressed in the same way as conditions from a morpho-syntactic point of view. We take the following features into account: 
− Part of speech tags. For example **recommandé**
should be a verb and not a noun, even if the form is ambiguous in French; 
− Tense and mood of the verb**. Present and future** 
tenses are relevant, as well as imperative and conditional moods. Imperative and future always have an injunctive value in the texts. Injunctive verbs (see lexical **cues) lose their injunctive property when used in a past tense.** 
Anaphoric cues. A basic and local analysis of anaphoric elements is performed. We especially focused on expressions such as dans ce cas, **dans les** 
N cas précédents (**in this case, in the n preceding** 
cases…**) which are very frequent in clinical documents. The recognition of such expressions is** based on a limited set of possible nouns that occurred in context, together with specific constraints 
(use of demonstrative pronouns, etc). 

Conjunctive cues (discourse connectors). **Conditions are mainly expressed through conjunctive** 
cues. The following forms are especially interesting: forms prototypically expressing conditions (**si,** 
en cas de, dans le cas où… if, in case of**…); Forms** 
expressing the locations of some elements (**chez, en** présence de... in presence of…**); Forms expressing** a temporal frame (**lorsque, au moment où, avant** de… when, before…)
Lexical cues. **Recommendations are mainly expressed through lexical cues. We have observed** 
forms prototypically expressing recommendations 
(recommander, prescrire, … recommend, prescribe), obligations (devoir, … shall**) or options** 
(pouvoir, … can**). Most of these forms are highly** ambiguous but can be automatically acquired from an annotated corpus. Some expressions from the medical domains can be automatically extracted using a terminology extractor (we use Yatea, see section 4, "Implementation"). 

## 3.3 **Basic Segmentation**

A basic segment **corresponds to a text sequence** expressing either a condition or a recommendation. It is most of the time a sentence, or a proposition inside a sentence. 

Some of the features described in the previous section may be highly ambiguous. For this reason basic segmentation is rarely done according to a single feature, but most of the time according to a bundle of features acquired from a representative corpus. For example, if a text sequence contains an injunctive **verb with an infinitive form at the beginning of a sentence, the whole sequence is typed as** 
action**. The relevant sets of co-occurring features** 
are automatically derived from a set of annotated practice guidelines, using the chi-square test to calculate the dissimilarity of distributions. 

After this step, the text is segmented into typed basic sequences expressing either a recommendation or a condition (the rest of the text is left untagged). 

## 3.4 **Computing Frames And Scopes**

As for quantifiers, a conditional element may have a scope (a frame**) that extends over several basic** segments. It has been shown by several authors (Halliday and Matthiessen, 2004; **Charolles, 2005)** working on different types of texts that conditions detached from the sentence have most of the time a scope beyond the current sentence whereas conditions included in a sentence (but not in the beginning of a sentence) have a scope which is limited to the current sentence. Accordingly we propose a two-step strategy: 1) the default segmentation is done, and 2) a revision process is used to correct the main errors caused by the default segmentation (corresponding to the norm). 

## Default Segmentation

We propose a strategy which makes use of the notion of default. By default: 

1. **Scope of a heading goes up to the next heading;** 
2. **Scope of an enumeration's header covers all** 
the items of the enumeration ; 
3. **If a conditional sequence is detached (in the** 
beginning of a paragraph or a sentence), its scope is the whole paragraph; 4. **If the conditional sequence is included in a** 
sentence, its scope is equal to the current sentence. 