Cases 3 and 4 cover 50-80% of all the cases, depending on the practice guidelines used. However, this default segmentation is revised and modified when a linguistic cue is a continuation mark within the text or when the default segmentation seems to contradict some cohesion cue. 

## Revising The Default Segmentation

There are two cases which require revising the default segmentation: 1) when a cohesion mark indicates that the scope is larger than the default unit; 2) when a rupture mark indicates that the scope is smaller. We only have room for two examples, which, we hope, give a broad idea of this process. 

1) Anaphoric relations are strong cues of text coherence: they usually indicate the continuation of a frame after the end of its default boundaries. 

![0_image_4.png](0_image_4.png)

Figure 2. The last sentence introduced by **dans les** 
deux cas is under the scope of the conditions introduced by **lorsque**3. 

In Figure 2, the expression **dans les deux cas** (in the two cases…**) is an anaphoric mark referring to** 
the two previous utterances. The scope of the conditional segment introduced by lorsque **(that would** 
normally be limited to the sentence it appears in) is thus extended accordingly. 

2) **Other discourse cues are strong indicators** 
that a frame must be closed before its default boundaries. These cues may indicate some contrastive, corrective or adversative information (cependant, en revanche… however**). Justifications cues** 
(en effet, en fait … in effect**) also pertain to this** class since a justification is not part of the action element of the GEM DTD. 

Figure 3 is a typical example. The linguistic cue en effet (in effect**) closes the frame introduced by** 

![0_image_0.png](0_image_0.png)

suffisante dans ces situations. 

(Prise en charge thérapeutique du patient dyslipidémique, 2005, p4)
Figure 3. **The last sentence contains a justification cue** 

![0_image_1.png](0_image_1.png)

![0_image_2.png](0_image_2.png)

![0_image_3.png](0_image_3.png) (en **effet) which limits the scope of the condition in the** preceding sentence. 

Chez les patients ayant initialement...(<1g/l) **since** 
this sequence should fill the explanation **element** of the GEM DTD and is not an action **element.** 

## 4 **Implementation**

Accurate discourse processing requires a lot of information ranging from lexical cues to complex cooccurrence of different features. We chose to implement these in a classic blackboard architecture 
(Englemore and Morgan, 1988). The advantages of this architecture for our problem are easy to grasp: each linguistic phenomenon can be treated as an independent agent; inference rules can also be coded as specific agents, and a facilitator controls the overall process. 

Basic linguistic information is collected by a set of modules called "linguistic experts". Each module is specialized in a specific phenomenon (text structure recognition, part-of-speech tagging, term spotting, etc.**). The text structure and text formatting elements are recognized using Perl scripts.** 
Linguistic elements are encoded in local grammars, mainly implemented as finite-state transducers 
(Unitex4**). Other linguistic features are obtained** 
using publicly available software packages, **e.g.** a part-of-speech tagger (Tree Tagger5**) and a term** 
extractor (Yatea6), etc**. Each linguist expert is encapsulated and produces annotations that are stored** 
in the database of facts, expressed in Prolog (we thus avoid the problem of overlapping XML tags, which are frequent at this stage). These annotations are indexed according to the textual clause they appear in, but linear ordering of the text is not cru-