
## Recommendations:

|           | Without domain   | With domain   |
|-----------|------------------|---------------|
| knowledge | knowledge        |               |
| P         | 1                | 1             |
| R         | .94              | .95           |
| P&R       | .97              | .97           |

Results are high for both conditions and recommendations. 

The benefit of domain knowledge is not evident from overall results. However, this information is useful for the tagging of titles corresponding to pathologies. For example, the title **Hypertension** 
artérielle (high arterial blood pressure) is equivalent to a condition introduced by in case of… **It is** 
thus important to recognize and tag it accurately, since further recommendations are under the scope of this condition. This cannot be done without domain-specific knowledge. 

The number of titles differs significantly from one practice guideline to another. When the number is high, the impact on the performance can be strong. Also, when several recommendations are dependent on the same condition, the system may fail to recognize the whole set of recommendations. 

Finally, we observed that not all conditions and recommendations have the same importance from a medical point of view - however, it is difficult to quantify this in the evaluation. 

## 5.4 **Evaluation Of The Automatic Recognition** Of The Scope Of Conditions

The scope of conditions is recognized with accuracy above .7 (we calculated this score using the same method as for inter-annotator agreement, see section 5.2). 

This result is encouraging, especially considering the large number of parameters involved in discourse processing. In most of successful cases the scope of a condition is recognized by the default rule (default segmentation, see section 3.4). However, some important cases are solved due to the detection of cohesion or boundary cue (especially titles). 

The system fails to recognize extended scopes 
(beyond the default boundary) when the cohesion marks correspond to lexical items which are related 
(synonyms, hyponyms or hypernyms) or to complex anaphora structures (nominal anaphora; hyponyms and hypernyms can be considered as a special case of nominal anaphora). Resolving these rarer complex cases would require "deep" domain knowledge which is difficult to implement using state-of-art techniques. 

## 6 **Conclusion**

We have presented in this paper a system capable of performing automatic segmentation of clinical practice guidelines. Our aim was to automatically fill an XML DTD from textual input. The system is able to process complex discourse structures and to compute the scope of conditional segments spanning several propositions or sentences. We show that inter-annotator agreement is high for this task and that the system performs well compared to previous systems. Moreover, our system is the first one capable of resolving the scope of conditions over several recommendations. 

As we have seen, discourse processing is difficult but fundamental for intelligent information access. We plan to apply our model to other languages and other kinds of texts in the future. The task requires at least adapting the linguistic components of our system (mainly the pre-processing stage). More generally, the portability of discoursebased systems across languages is a challenging area for the future. 

## References

R.C. Brownson, E.A. Baker, T.L. Leet, K.N. Gillespie. 

2003. Evidence-based public health**. Oxford University Press. Oxford, UK.** 
M. Charolles. 2005. "Framing adverbials and their role in discourse cohesion: from connexion to forward labeling". **Papers of the Symposium on the** Exploration and Modelling of Meaning **(Sem'05),** Biarritz. France. 

R. Englemore and T. Morgan. 1988. Blackboard Systems**. Addison-Wesley, USA.** 
G. Georg and M.-C. Jaulent. 2005. "An Environment for Document Engineering of Clinical Guidelines". Proceedings of the American Medical Informatics Association**. Washington DC. USA. pp. 276–280.** 
M.A.K. Halliday and R. Hasan. 1976. Cohesion in English**. Longman. Harlow, UK.** 
M.A.K. Halliday and C. Matthiessen. 2004. **Introduction** 
to functional grammar (3rd **ed.). Arnold. London, UK.** 
G. Kolata. 2004. "Program Coaxes Hospitals to See Treatments Under Their Noses". **The New York** 
Times. December 25, 2004. 