# A Robust Linguistic Platform For Efficient And Domain Specific Web Content Analysis

Thierry Hamon, Adeline Nazarenko, Thierry Poibeau, Sophie Aubin, Julien **Derivière,** LIPN - UMR CNRS 7030 99, avenue J.B. Clément F-93430 Villetaneuse, France firstname.name@lipn.univ-paris13.fr Abstract Web semantic access in specific domains calls for specialized search engines with enhanced semantic querying and indexing capacities, which pertain both to information retrieval (IR) and to information extraction (IE). A
rich linguistic analysis is required either to identify the relevant semantic units to index and weight them according to linguistic specific statistical distribution, or as the basis of an information extraction process. Recent developments make Natural Language Processing (NLP) techniques reliable enough to process large collections of documents and to enrich them with semantic annotations. This paper focuses on the design and the development of a text processing platform, Ogmios, which has been developed in the ALVIS project. The Ogmios platform exploits existing NLP modules and resources, which may be tuned to specific domains and produces linguistically annotated documents. We show how the three constraints of genericity, domain semantic awareness and performance can be handled all together.

## 1. Introduction

Search engines like Google or Yahoo offer access to billions of textual web pages. These tools are very popular and seem to be sufficient for a large number of general user queries on the Internet. However, some other queries are more complex, requiring specific knowledge or processing strategies: no really satisfactory solution exists for these requests. There is thus a need for more specific search engines dedicated to specialized domain or users. Let us consider the case of text mining in Microbiology for example. Given the specificity and the reliability of the information that is sought by scientists, it is clear than one needs more than existing search engines. Even if recent developments in biology and biomedicine are reported in large bibliographical databases (e.g. Flybase, specialized on Drosophilia Menogaster or Medline), such databases and the associated searching functionalities are not sufficient to satisfy biologists' specific information needs, such as finding information on gene interactions in order to progressively figure out a whole interaction network. We previously argued that looking for this kind of relational information requires a domain-specific linguistic analysis and parsing of the documents (Alphonse et *al.,* 2004). The ALVIS project aims at developing an open source search engine, with extended semantic search facilities. Compared to state of the art search engines (like Google, the most popular one), the ALVIS search engine is domain specific. It relies on a specialized crawler, which selects the web pages on terminological grounds. Indexing exploits various types of linguistic and domain specific annotation. Through a dedicated user interface, the ALVIS search engine processes the query more accurately, taking into account the topic and the context of search to refine both the query and the document analysis.