
## 6.1. The Initial Parser Choice

LP presents several advantages among which the robustness, the good quality of the parsing, the underlying dependency formalism and the declarative format of its lexicon.

In order to test various parsers, a corpus has been built from Medline4 abstracts (in English)
dealing with transcription in Bacillus *subtilis* (Aubin et al., 2005), named henceforth MED-TEST corpus. Our test corpus contains 212 randomly selected sentences (5,992 words), which contain an average of 25.4 words (from 8 to 59). Despite its relatively small size, this corpus is a good sample of the sublanguage of genomics. Medline abstracts present the following characteristics: they are made of long and syntactically complex sentences, specialized vocabulary, scientific notations and numerous non grammatical constructions. From the results of the evaluation that we did on different parsers, it turned out that dependency-based parsers have better results on long and complex sentences, particularly with coordination. For example, LP seems to offer better performance than a constituent-based parser applied on Medline abstracts (see (Grover, 2004) for an experiment using a GPSG parser). This conclusion is shared by (Ding, 2003) who also worked on the same kind of corpus. Other experiments have also shown that the parser performance varies from one corpus to another. In the context of the ExtrAns project, (Molla et al., 2000) showed that 76% of 2,781 sentences from a Unix manpage corpus were completely parsed by LP independently to the parsing quality, while we reach only 54% on the biological corpus. When looking at the quality of the parses, we noticed different kinds of errors depending either on the biological domain or on more general linguistic difficulties like ambiguous constructions. We propose three solutions to address these issues: text normalization, terminology analysis and lexicon/grammar adaptation.

## 6.2. Diagnosis And Adaptation

Our analysis of the performance of the Link grammar on the biological corpus confirms previous works. The main problems can be classified along the following axes.

## Textual Noise

Scientific texts present particularities that we chose to handle in a normalization step prior to the parsing. First, the segmentation in sentences and words was taken off from the parser and enriched with named entities recognition and rules specific to the biological domain. We also delete some extra-textual information that alters parsing quality (such as citations, for instance).

## Unknown Words

In a corpus made of full Medline abstracts, we identified 6,005 out-of-lexicon forms (45,804 occurrences) among 12,584 distinct words, *i.e.* 47.72%. They are mostly latin words, numbers, DNA sequences, gene names, misspellings and technical lexicon. However, LP includes a module that can assign a syntactic category to an unknown word. It is based on the word suffix. Modifying the morpho-guessing (MG) module seemed a better strategy than extending the dictionary since biological objects differ from an organism to another (Grover (2004) also reports a similar process). We then created 19 new MG classes for nouns (–ase, *-ity*, etc.) and adjectives (–al, *-ous*, etc.) along with their rule. At the same