ones have a significant impact on information retrieval, information extraction or even extraction rule learning. In that respect, the platform can be viewed as a modular software architecture that can be configured to achieve various tasks.

## 3.1. Specific Constraints

The reuse of NLP tools imposes specific constraints regarding software engineering and processing domain-specific documents requires tuning resources to better fit the data. From the software engineering point of view, the constraints mainly concern the input/output formats of the integrated NLP tools. Each tool has its own input and output format. Linking together several tools requires defining an interchange format. This engineering point of view is important for testing various combinations of annotations. The second type of constraints is the cost linguistic analysis in terms of processing time. The main pitfall is the deep syntactic dependency parsing which is time consuming) and which lead us to design a distributed architecture. A domain specific annotation platform also requires lexical and ontological resources or the tuning of NLP tools such as the Part-of-Speech tagger or parser. For instance, we have argued in (Alphonse et al., 2004) that identification of gene interaction requires gene name tagging, which relates to traditional named entity recognition, term recognition and a reliable syntactic analysis.

## 3.2. General Architecture

The different processing steps are traditionally separated in modules (Bontcheva et al., 2004).

Each module carries out a specific processing step: named entity recognition, word segmentation, POS tagging, parsing, semantic tagging or anaphora resolution. It wraps an NLP tool to ensure the conformity of the input/output format with the DTD. Annotations are recorded in an XML stand-off format to deal with the heterogeneity of NLP tools input/output
(the DTD is fully described in (Nazarenko et al., 2006)). The modularity of the architecture simplifies the substitution of a tool by another. Tuning to a specific field is insured by the exploitation of specialized resources by each module. For instance, a targeted species or gene list can be added to the biology-specific named entity recognizer to process Medline abstracts. In the ALVIS project, the problem of acquiring automatically these specialized resources from a training corpus is also addressed (see Figure 1 and (Alphonse et al., 2004)) but this question falls out of the scope of the present paper. Figure 2 gives an overview of the architecture. The various modules composing the NLP line are represented as boxes. The description of these modules is given in section 4. The arrows represent the data processing flow. Intermediary levels of annotations can be produced if the complete NLP line is not used. For instance, anaphora resolution is seldom activated.