- Named Entity tagging takes place very early in the NLP line because unrecognized named entities hinder most NLP steps, in many sublanguages;
- Terminological tagging is used as such but is also considered as an aid for syntactic parsing. As this latter step is time consuming, we exploit the fact that terminological analysis simplifies the parsing cost.
For each document, the NLP modules are called sequentially. The outputs of the modules are stored in memory until the end of the processing. XML output is recorded at the end of the document processing.

## 4. Description Of The Nlp Modules

This section describes the different NLP modules. Il also explains what is the expected impact of each linguistic annotation step on IR or IE performance.

## Named Entity Tagging

The Named Entity tagging module aims at annotating semantic units, with syntactic and semantic types. Each text sequence corresponding to a named entity is tagged with a unique tag corresponding to its semantic value (for example a "gene" type for gene names, "species" type for species names, etc.). We use the TagEN Named Entity tagger (Berroyer, 2004), which is based on a set of linguistic resources and grammars. Named entity tagging has a direct impact on search performance when the query contains one or two named entities, as those semantic units are have a high discriminative power.

## Word And Sentence Segmentation

This module identifies sentence and word boundaries. We use simple regular expressions, based on the algorithm proposed in (Grefenstette & Tapanainen, 1994). Part of the segmentation has been implicitly performed during the Named Entity tagging to solve some ambiguities such as the abbreviation dot in the sequence "B. subtilis", which could be understood as a full stop if it were not analyzed beforehand.

## Morpho-Syntactic Tagging

This module aims at associating a part of speech (POS) tag to each word. It assumes that the word and sentence segmentation has been performed. We are using a probabilistic Part-Of-Speech tagger: TreeTagger (Schmid, 1997). The POS tags are not used as such for IR but POS tagging facilitates the rest of the linguistic processing.

## Lemmatization

This module associates its lemma, i.e. its canonical form, to each word. The experiments presented in (Moreau, 2006) show that this morphological normalization increases the performance of search engines. If the word cannot be lemmatized (for instance a number or a foreign word), the information is omitted. This module assumes that word segmentation and morpho-syntactic information are provided. Even if it is a distinct module, we currently exploit the TreeTagger output which provides lemma as well as POS tags.

## Terminology Tagging

This module aims at recognizing the domain specific phrases in a document, like *gene* expression or spore coat *cell*. These phrases considered as the most relevant terminological items. They can be provided through terminological resources such as the Gene Ontology (GOConsortium, 2001), the MeSH (MeSH) or more widely UMLS (UMLS). They can also be acquired through corpus analysis (see Figure 1). Providing a given terminology tunes the term