
## 6 Improving Milp-Dec

We now discuss two heuristics for improving the space and time requirement of formulating and solving MILP-Dec.

## 6.1 Identifying Dominated Sequences

The number of variables required in the MILP-Dec can be minimized by using variables for only those sequences of each agent that are not *dominated*. Dominated sequences need not be represented in the MILP-Dec because there always exists an optimal κjoint-policy in which none of the policies contains a dominated sequence. We first define dominated sequences of length κ. Given sequences p and p
′ of length κ of the ith agent, p
′shall be called a *co-sequence* of p if it is identical to p except for its last action. Let C(p) denote the set of co-sequences of p. Then, p is said to be dominated if there exists a probability distribution θ over C(p), such that for every joint-sequence q of length κ in which the sequence of the ith agent is p, the following is true:

$$\nu(q)\leq\sum_{p^{\prime}\in{\mathcal{C}}(p)}\theta(p^{\prime})\nu(q^{\prime})$$
$$(30)^{\frac{1}{2}}$$
′) (30)
in which q
′ = (q1, **. . .**, qi−1, p
′, qi+1, **. . .**, qn). Dominated sequences of length κ can be identified through *iterated elimination*. Identifying sequences of lengths less than κ is easier. A sequence p of length t is a *descendant* of a sequence p
′′ of length **j < t**
if the first j actions and j - 1 observations in p are identical to the j actions and j - 1 observations in p
′′. A sequence p
′′ of length j is dominated if every descendant of p
′′
is dominated. So, for each agent, we first identify dominated sequences of length κ, and then working backwards, we identify dominated sequences of lengths less than κ.

Note that if dominated sequences are not represented by variables in MILP-Dec, then in each joint-policy constraint the = sign must be replaced by the ≤ sign. The MILP that results when dominated sequences of all the agents are not represented by variables in MILP-Dec and the above modifications are made shall be denoted by MILP-Pr-Dec.

## 6.2 Adding Bounds Into Milp-Dec

The MILP solver can be guided in its path selection in the tree of LP problems or made to terminate as early as possible by providing lower and/or upper bounds on the objective function. In this paper, we wish to illustrate the importance of integrating bounds in MILP-Dec, and so we have used rather loose bounds. Given V(t), the value of an optimal t-joint-policy, a lower bound on the value of the optimal (t **+ 1)**-jointpolicy is, ℓ = V(t**) + max**
a∈A
min s∈S
R
a s(31)
For an upper bound, the value u of an optimal κ-step policy of the Pomdp corresponding to the Dec-Pomdp can be used. This value can be determined by the linear program
(32)-(35) which also finds the optimal κ-step policy for the Pomdp. Let S
t denote

 $\begin{array}{l}\texttt{IIIa}\texttt{L}\texttt{i}\texttt{m}\texttt{i}\texttt{n}\texttt{l}\texttt{i}\\ \texttt{a}\in A\quad\texttt{s}\in\texttt{S}\end{array}$. 