# A Leaf Recognition Algorithm For Plant Classification Using Probabilistic Neural Network

Stephen Gang Wu 1
, Forrest Sheng Bao 2
, Eric You Xu 3
, Yu-Xuan Wang 4
, Yi-Fan Chang 5 and Qiao-Liang Xiang 4 1 Institute of Applied Chemistry, Chinese Academy of Science, P. R. China 2 Dept. of Computer Science, Texas Tech University, USA
3 Dept. of Computer Science & Engineering, Washington University in St. Louis, USA
4 School of Information & Telecommunications Eng., Nanjing Univ. of P & T, P. R. China 5 Dept. of Electronic Engineering, National Taiwan Univ. of Science & Technology, Taiwan, R. O. China Corresponding author's E-mail : shengbao@ieee.org Abstract—In this paper, we employ Probabilistic Neural Network (PNN) with image and data processing techniques to implement a general purpose automated leaf recognition for **plant** classification. 12 leaf features are extracted and orthogonalized into 5 principal variables which consist the input vector of the PNN. The PNN is trained by 1800 leaves to classify 32 kinds of plants with an accuracy greater than 90%. Compared with other approaches, our algorithm is an accurate artificial intelligence approach which is fast in execution and easy in implementation.

Index Terms**—Probabilistic Neural Network, feature extraction, leaf recognition, plant classification**

## I. Introduction

Plants exist everywhere we live, as well as places without us. Many of them carry significant information for the development of human society. The urgent situation is that many plants are at the risk of extinction. So it is very necessary to set up a database for plant protection [1]–[4]. We believe that the first step is to teach a computer how to classify plants.

Compared with other methods, such as cell and molecule biology methods, classification based on leaf image is the first choice for leaf plant classification. Sampling leaves and photoing them are low-cost and convenient. One can easily transfer the leaf image to a computer and a computer can extract features automatically in image processing techniques.

Some systems employ descriptions used by botanists [5]–
[8]. But it is not easy to extract and transfer those features to a computer automatically. This paper tries to prevent human interference in feature extraction.

It is also a long discussed topic on how to extract or measure leaf features [9]–[15]. That makes the application of pattern recognition in this field a new challenge [1] [16]. According to [1], data acquisition from living plant automatically by the computer has not been implemented.

Several other approaches used their pre-defined features.

Miao et al. proposed an evidence-theory-based rose classification [3] based on many features of roses. *Gu et al.* tried leaf recognition using skeleton segmentation by wavelet transform and Gaussian interpolation [17]. *Wang et al.* used a moving median center (MMC) hypersphere classifier [18]. Similar method was proposed by *Du et al.* [1]. Their another paper proposed a modified dynamic programming algorithm for leaf shape matching [19]. *Ye et al.* compared the similarity between features to classify plants [2].

Many approaches above employk-nearest neighbor (k-NN)
classifier [1] [17] [18] while some papers adopted Artificial Neural Network (ANN). *Saitoh et al.* combined flower and leaf information to classify wild flowers [20]. *Heymans et al.* proposed an application of ANN to classify opuntia species [21]. *Du et al.* introduced shape recognition based on radial basis probabilistic neural network which is trained by orthogonal least square algorithm (OLSA) and optimized by recursive OLSA [22]. It performs plant recognition through modified Fourier descriptors of leaf shape.

Previous work have some disadvantages. Some are only applicable to certain species [3] [16] [21]. As expert system, some methods compare the similarity between features [2] [8]. It requires pre-process work of human to enter keys manually. This problem also happens on methods extracting features used by botanists [7] [16].

Among all approaches, ANN has the fastest speed and best accuracy for classification work. [22] indicates that ANN
classifiers (MLPN, BPNN, RBFNN and RBPNN) run faster than k-NN (k=1, 4) and MMC hypersphere classifier while ANN classifiers advance other classifiers on accuracy. So this paper adopts an ANN approach.

This paper implements a leaf recognition algorithm using easy-to-extract features and high efficient recognition algorithm. Our main improvements are on feature extraction and the classifier. All features are extracted from digital leaf image. Except one feature, all features can be extracted automatically.

12 features are orthogonalized by Principal Components Analysis (PCA) [23]. As to the classifier, we use PNN [24] for its fast speed and simple structure. The whole algorithm is easyto-implement, using common approaches.

The rest of this paper is organized as follows. Sec. II
discusses image pre-processing. Sec. III introduces how 12 leaf features are extracted. PCA and PNN are discussed in Sec. IV. Experimental results are given in Sec. V. Future work on improving our algorithm is mentioned in Sec. VI. Sec. VII
concludes this paper.