

![0_image_0.png](0_image_0.png)

## Ii. Image Pre-Processing A. Converting Rgb Image To Binary Image

The leaf image is acquired by scanners or digital cameras.

Since we have not found any digitizing device to save the image in a lossless compression format, the image format here is JPEG. All leaf images are in 800 x 600 resolution. There is no restriction on the direction of leaves when photoing.

An RGB image is firstly converted into a grayscale image.

Eq. 1 is the formula used to convert RGB value of a pixel into its grayscale value.

gray = 0.2989 ∗ R + 0.5870 ∗ G + 0.1140 ∗ B (1)
where R, G, B correspond to the color of the pixel, respectively. The level to convert grayscale into binary image is determined according to the RGB histogram. We accumulate the pixel values to color R, G, B respectively for 3000 leaves and divide them by 3000, the number of leaves. The average histogram to RGB of 3000 leaf images is shown as Fig. 2.

![0_image_2.png](0_image_2.png) 

There are two peaks in every color's histogram. The left peak refers to pixels consisting the leaf while the right peak refers to pixels consisting the white background. The lowest point between two peaks is around the value 242 on the average. So we choose the level as 0.95 (242/255=0.949). The output image replaces all pixels in the input image with luminance greater than the level by the value 1 and replaces all other pixels by the value 0.

A rectangular averaging filter of size 3 × 3 is applied to filter noises. Then pixel values are rounded to 0 or 1.

B. Boundary Enhancement
When mentioning the leaf shape, the first thing appears in
your mind might be the margin of a leaf. Convolving the image
with a Laplacian filter of following 3 × 3 spatial mask:
$$\begin{array}{l l l}{{0}}&{{1}}&{{0}}\\ {{1}}&{{-4}}&{{1}}\\ {{0}}&{{1}}&{{0}}\end{array}$$
we can have the margin of the leaf image.
An example of image pre-processing is illustrated in Fig. 3.
To make boundary as a black curve on white background, the "0" "1" value of pixels is swapped.

![0_image_1.png](0_image_1.png)

## Iii. Feature Extraction

In this paper, 12 commonly used digital morphological features (DMFs), derived from 5 basic features, are extracted so that a computer can obtain feature values quickly and automatically (only one exception).

## A. Basic Geometric Features

Firstly, we obtain 5 basic geometric features.

1) Diameter: The diameter is defined as the longest distance between any two points on the margin of the leaf. It is denoted as D.

2) Physiological Length: The only human interfered part of our algorithm is that you need to mark the two terminals of the main vein of the leaf via mouse click. The distance between the two terminals is defined as the physiological length. It is denoted as Lp.

3) Physiological Width: Drawing a line passing through the two terminals of the main vein, one can plot infinite lines orthogonal to that line. The number of intersection pairs between those lines and the leaf margin is also infinite. The longest distance between points of those intersection pairs is defined at the physiological width. It is denoted as Wp.

Since the coordinates of pixels are discrete, we consider two lines are orthogonal if their degree is 90◦ ± 0.5
◦
.

The relationship between physiological length and physiological width is illustrated in Fig. 4.