

![0_image_0.png](0_image_0.png)

## C. Network Structure

The network structure in our purposed scheme is illustrated in Fig. 5. We adopt symbols and notations used in the book Neural Network Design [27]. These symbols and notations are also used by MATLAB Neural Network Toolbox [28].

Dimensions of arrays are marked under their names.

1) Input Layer: The input vector, denoted as p, is presented as the black vertical bar in Fig. 5. Its dimension is R × 1. In this paper, R = 5.

2) Radial Basis Layer: In Radial Basis Layer, the vector distances between input vector p and the weight vector made of each row of weight matrix W are calculated. Here, the vector distance is defined as the dot product between two vectors [29]. Assume the dimension of W is Q × R. The dot product between p and the i-th row of W produces the i-th element of the distance vector ||W− p||, whose dimension is Q × 1, as shown in Fig. 5. The minus symbol, "−", indicates that it is the distance between vectors.

Then, the bias vector b is combined with ||W − p|| by an element-by-element multiplication, represented as "·∗" in Fig. 5. The result is denoted as n = ||W − p**|| · ∗**p.

The transfer function in PNN has built into a distance criterion with respect to a center. In this paper, we define it as

$$r a d b a s(n)=e^{-n^{2}}$$

(2)
Each element of n is substituted into Eq. 2 and produces corresponding element of a, the output vector of Radial Basis Layer. We can represent the i-th element of a as

$$a_{i}=r a d b a s(||\mathbf{W}_{i}-\mathbf{p}||\cdot*\mathbf{b}_{i})$$
ai = radbas(||Wi − p**|| · ∗**bi) (3)
where Wiis the vector made of the i-th row of W and biis the i-th element of bias vector b.

3) Some characteristics of Radial Basis Layer: The i-th element of a equals to 1 if the input p is identical to the i-th row of input weight matrix W. A radial basis neuron with a weight vector close to the input vector p produces a value near 1 and then its output weights in the competitive layer will pass their values to the competitive function which will be discussed later. It is also possible that several elements of a are close to 1 since the input pattern is close to several training patterns.

4) Competitive Layer: There is no bias in Competitive Layer. In Competitive Layer, the vector a is firstly multiplied with layer weight matrix M, producing an output vector d. The competitive function, denoted as C in Fig. 5, produces a 1 corresponding to the largest element of d, and 0's elsewhere. The output vector of competitive function is denoted as c. The index of 1 in c is the number of plant that our system can classify. It can be used as the index to look for the scientific name of this plant. The dimension of output vector, K, is 32 in this paper.

## D. Network Training

Totally 1800 pure leaves are sampled to train this network.

Those leaves are sampled in the campus of Nanjing University and Sun Yat-Sen arboretum, Nanking, China. Most of them are common plants in Yangtze Delta, China. Details about the leaf numbers of different kinds of plants are given in Table I. The reason why we sample different pieces of leaves to different plants is the difficulty to sample leaves varies on plants.

1) Radial Basis Layer Weights: W is set to the transpose of R×Q matrix of Q training vectors. Each row of W consists of 5 principal variables of one trainging samples. Since 1800 samples are used for training, Q = 1800 in this paper.

2) Radial Basis Layer Biases: All biases in radial basis layer are all set to √ln 0.5/s resulting in radial basis functions that cross 0.5 at weighted inputs of ±s. s is called the spread constant of PNN.

The value of s can not be selected arbitrarily. Each neuron in radial basis layer will respond with 0.5 or more to any input vectors within a vector distance of s from their weight vector. A too small s value can result in a solution that does not generalize from the input/target vectors used in the design. In contrast, if the spread constant is large enough, the radial basis neurons will output large values (near 1.0) for all the inputs used to design the network.

In this paper, the s is set to 0.03(≃ 1/32) according to our experience.

3) Competitive Layer Weights: M is set to K×Q matrix of Q target class vectors. The target class vectors are converted from class indices corresponding to input vectors. This process generates a sparse matrix of vectors, with one 1 in each column, as indicated by indices. For example, if the i-th