
## Vii. Conclusion

This paper introduces a neural network approach for plant leaf recognition. The computer can automatically classify 32 kinds of plants via the leaf images loaded from digital cameras or scanners. PNN is adopted for it has fast speed on training and simple structure. 12 features are extracted and processed by PCA to form the input vector of PNN. Experimental result indicates that our algorithm is workable with an accuracy greater than 90% on 32 kinds of plants. Compared with other methods, this algorithm is fast in execution, efficient in recognition and easy in implementation. Future work is under consideration to improve it.

## Acknowledgements

Prof. Xin-Jun Tian, Department of Botany, School of Life Sciences, Nanjing University provided the lab and some advises for this research.

Yue Zhu, a master student of Department of Botany, School of Life Sciences, Nanjing University, helped us sampling plant leaves.

Ang Li and Bing Chen from Institute of Botany, Chinese Academy of Science, provided us some advises on plant taxonomy and searched the scientific name for plants.

Shi Chen, a PhD student from School of Agriculture, Pennsylvania State University, initiated another project which inspired us this research.

The authors also wish to thank secretary Crystal HwanMing Chan, for her assistance to our project.

## References

[1] J.-X. Du, X.-F. Wang, and G.-J. Zhang, "Leaf shape based plant species recognition," *Applied Mathematics and Computation*, vol. 185, 2007.

[2] Y. Ye, C. Chen, C.-T. Li, H. Fu, and Z. Chi, "A computerized plant species recognition system," in *Proceedings of 2004 International Symposium on Intelligent Multimedia, Video and Speech Processing*, Hong Kong, October 2004.

[3] Z. Miao, M.-H. Gandelin, and B. Yuan, "An oopr-based rose variety recognition system," *Engineering Applications of Artificial Intelligence*, vol. 19, 2006.

[4] R. de Oliveira Plotze, M. Falvo, J. G. Pdua, L. C. Bernacci, M. L. C.

Vieira, G. C. X. Oliveira, and O. M. Bruno, "Leaf shape analysis using the multiscale minkowski fractal dimension, a new morphometric method: a study with passifliora (passifloraceae)," Canada Journal of Botany, vol. 83, 2005.

[5] M. J. Dallwitz, "A general system for coding taxonomic descriptions,"
Taxon, vol. 29, 1980.

[6] H. Fu, Z. Chi, D. Feng, and J. Song, "Machine learning techniques for ontology-based leaf classification," in *IEEE 2004 8th International* Conference on Control, Automation, Robotics and Vision, Kunming, China, 2004.

[7] D. Warren, "Automated leaf shape description for variety testing in chrysanthemums," in Proceedings of IEE 6th International Conference Image Processing and Its Applications, 1997.

[8] T. Brendel, J. Schwanke, P. Jensch, and R. Megnet, "Knowledgebased object recognition for different morphological classes of plants,"
Proceedings of SPIE, vol. 2345, 1995.

[9] Y. Li, Q. Zhu, Y. Cao, and C. Wang, "A leaf vein extraction method based on snakes technique," in *Proceedings of IEEE International* Conference on Neural Networks and Brain, 2005.

[10] H. Fu and Z. Chi, "Combined thresholding and neural network approach for vein pattern extraction from leaf images," *IEE Proceedings-Vision,* Image and Signal Processing, vol. 153, no. 6, December 2006.
6

[11] Y. Nam, E. Hwang, and K. Byeon, "Elis: An efficient leaf image retrieval system," in *Proceedings of International Conference on Advances in* Pattern Recognition 2005, ser. LNCS 3687. Springer, 2005.

[12] H. Fu and Z. Chi, "A two-stage approach for leaf vein extraction," in Proceedings of IEEE International Conference on Neural Networks and Signal Processing, Nanjing, China, 2003.

[13] Z. Wang, Z. Chi, and D. Feng, "Shape based leaf image retrieval,"
IEE Proceedings-Vision, Image and Signal Processing, vol. 150, no. 1, February 2003.

[14] H. QI and J.-G. YANG, "Sawtooth feature extraction of leaf edge based on support vector machine," in Proceedings of the Second International Conference on Machine Learning and Cybernetics, November 2003.

[15] S. M. Hong, B. Simpson, and G. V. G. Baranoski, "Interactive venationbased leaf shape modeling," *Computer Animation and Virtual Worlds*,
vol. 16, 2005.

[16] F. Gouveia, V. Filipe, M. Reis, C. Couto, and J. Bulas-Cruz, "Biometry:
the characterisation of chestnut-tree leaves using computer vision," in Proceedings of IEEE International Symposium on Industrial *Electronics*,
Guimar˜aes, Portugal, 1997.

[17] X. Gu, J.-X. Du, and X.-F. Wang, "Leaf recognition based on the combination of wavelet transform and gaussian interpolation," in *Proceedings* of International Conference on Intelligent Computing 2005, ser. LNCS 3644. Springer, 2005.

[18] X.-F. Wang, J.-X. Du, and G.-J. Zhang, "Recognition of leaf images based on shape features using a hypersphere classifier," in *Proceedings* of International Conference on Intelligent Computing 2005, ser. LNCS 3644. Springer, 2005.

[19] J.-X. Du, D.-S. Huang, X.-F. Wang, and X. Gu, "Computer-aided plant species identification (capsi) based on leaf shape matching technique," Transactions of the Institute of Measurement and Control, vol. 28, 2006.

[20] T. K. Takeshi Saitoh, "Automatic recognition of wild flowers," in Proceedings of 15th International Conference on Pattern Recognition
(ICPR'00), vol. 2, 2000.

[21] B. C. Heymans, J. P. Onema, and J. O. Kuti, "A neural network for opuntia leaf-form recognition," in Proceedings of IEEE International Joint Conference on Neural Networks, 1991.

[22] J. Du, D. Huang, X. Wang, and X. Gu, "Shape recognition based on radial basis probabilistic neural network and application to plant species identification," in Proceedings of 2005 International Symposium of Neural Networks, ser. LNCS 3497. Springer, 2005.

[23] J. Shlens. (2005, December) A tutorial on principal component analysis.

[Online]. Available: http://www.cs.cmu.edu/∼elaw/papers/pca.pdf
[24] D. F. Specht, "Probabilistic neural networks," *Neural Networks*, vol. 3, 1990.

[25] R. C. Gonzalez, R. E. Woods, and S. L. Eddins, *Digital Image Processing Using MATLAB*. Prentice Hall, 2004.

[26] T. Master, *Practical Neural Network Recipes*. New York: John Wiley, 1993.

[27] M. T. Hagan, H. B. Demut, and M. H. Beale, *Neural Network Design*,
2002.

[28] (2007) Matlab neural network toolbox documentation. MathWorks. Inc. [Online]. Available:
http://www.mathworks.com/access/helpdesk/help/toolbox/nnet/radial10.html\#8378
[29] D. F. Specht, "Probabilistic neural networks for classification mapping, or associative memory," in *Proceedings of IEEE International Conference on Neural Networks*, vol. 1, 1988.

[30] I. Motoyoshi, S. Nishida, L. Sharan, and E. H. Adelson, "Image statistics and the perception of surface qualities," *Nature*, vol. 447, May 2007.