universal optimal problem solvers.

Consider a learning robotic agent with a single life which consists of discrete cycles or time steps t = 1, 2**, . . . , T** . Its total lifetime T may or may not be known in advance. In what follows,the value of any time-varying variable Q at time t (1 ≤ t ≤ T ) will be denoted by Q(t), the ordered sequence of values Q(1)**, . . . , Q**(t) by Q(≤ t), and the (possibly empty) sequence Q(1), . . . , Q(t − 1) by Q(< t).

At any given t the robot receives a real-valued input vector x(t) from the environment and executes a real-valued action y(t) which may affect future inputs; at times t < T its goal is to maximize future success or *utility*

$$u(t)=E_{\mu}\left[\sum_{\tau=t+1}^{T}\,r(\tau)\,\,\,\Bigg|\,\,\,h(\leq t)\right],$$
$$(1)$$

where r(t) is an additional real-valued reward input at time t, h(t) the ordered triple
[x(t), y(t), r(t)] (hence h(≤ t) is the known history up to t), and Eµ(**· | ·**) denotes the conditional expectation operator with respect to some possibly unknown distribution µ from a set M of possible distributions. Here M reflects whatever is known about the possibly probabilistic reactions of the environment. For example, M may contain all computable distributions [11, 35]. Note that unlike in most previous work by others [36], there is just one life, no need for predefined repeatable trials, no restriction to Markovian interfaces between sensors and environment, and the utility function implicitly takes into account the expected remaining lifespan Eµ(T | h(≤ t)) and thus the possibility to extend it through appropriate actions [29].

Any formal problem or sequence of problems can be encoded in the reward function. For example, the reward functions of many living or robotic beings cause occasional hunger or pain or pleasure signals etc. At time t an optimal AI will make the best possible use of experience h(≤ t) to maximize u(t). But how?

## 2.5 Universal, Mathematically Optimal, But Incomputable Ai

Unbeknownst to many traditional AI researchers, there is indeed an extremely general "best" way of exploiting previous experience. At any time t, the recent theoretically optimal yet practically infeasible reinforcement learning (RL) algorithm AIXI
[11] uses Solomonoff's above-mentioned universal prediction scheme to select those action sequences that promise maximal future reward up to some horizon, given the current data h(≤ t). Using a variant of Solomonoff's universal probability mixture ξ, in cycle t+ 1, AIXI selects as its next action the first action of an action sequence maximizing ξ-predicted reward up to the horizon. Hutter's recent work [11] demonstrated AIXI's optimal use of observations as follows. The Bayes-optimal policy p ξ based on the mixture ξ is self-optimizing in the sense that its average utility value converges asymptotically for all µ ∈ M to the optimal value achieved by the (infeasible) Bayesoptimal policy p µ which knows µ in advance. The necessary condition that M admits self-optimizing policies is also sufficient.

Of course one cannot claim the old AI is devoid of formal research! The recent approach above, however, goes far beyond previous formally justified but very limited AI-related approaches ranging from linear perceptrons [17] to the A∗-algorithm [18].