# Qualitative Belief Conditioning Rules (Qbcr)

Florentin Smarandache Department of Mathematics University of New Mexico Gallup, NM 87301, U.S.A.

smarand@unm.edu Jean Dezert ONERA
29 Av. de la Division Leclerc 92320 Chˆatillon, France.

Jean.Dezert@onera.fr Abstract - In this paper we extend the new family of (quantitative) Belief Conditioning Rules (BCR) recently developed in the Dezert-Smarandache Theory (DSmT) to their qualitative counterpart for belief revision. Since the revision of quantitative as well as qualitative belief assignment given the occurrence of a new event (the conditioning constraint) can be done in many possible ways, we present here only what we consider as the most appealing Qualitative Belief Conditioning Rules (QBCR) which allow to revise the belief directly with words and linguistic labels and thus avoids the introduction of ad-hoc translations of quantitative beliefs into quantitative ones for solving the problem.

Keywords: **qualitative belief, belief conditioning rules (BCRs), computing with words, Dezert-Smarandache**
Theory (DSmT), reasoning under uncertainty.

## 1 Introduction

In this paper, we propose a simple arithmetic of linguistic labels which allows a direct extension of quantitative Belief Conditioning Rules (BCR) proposed in the DSmT [3, 4] framework to their qualitative counterpart. Qualitative beliefs assignments are well adapted for manipulated information expressed in natural language and usually reported by human expert or AI-based expert systems. A **new method for computing directly with words**
(CW) for combining and conditioning qualitative information is presented. CW, more precisely computing with linguistic labels, is usually more vague, less precise than computing with **numbers, but it is expected to offer a** better robustness and flexibility for combining uncertain and conflicting human reports than computing with numbers because in most of cases human experts are less efficient to provide (and to justify) precise quantitative beliefs than qualitative beliefs.

Before extending the quantitative DSmT-based conditioning rules to their qualitative counterparts, it will be necessary to define few but new important operators on linguistic labels and what is a qualitative belief assignment. Then we will show though simple examples how the combination of qualitative beliefs can be obtained in the DSmT framework.

## 2 Qualitative Operators And Belief Assignments

Since one wants to compute directly with words (CW) instead of numbers, we define without loss of generality a finite set of linguistic labelsL˜={L1, L2, . . . , Ln} wheren≥ 2 is an integer.L˜ **is endowed with a total**
order relationship≺, so thatL1≺L2≺ . . .≺Ln**. To work on a close linguistic set under linguistic addition**
and multiplication operators, one extendsL˜ with two extreme valuesL0 andLn+1 whereL0 **corresponds to**
the minimal qualitative value andLn+1 **corresponds to the maximal qualitative value, in such a way that** L0≺L1≺L2≺ . . .≺Ln≺Ln+1 where≺ **means inferior to, or less, or smaller (in quality) than, etc.** Therefore, one will work on the extended ordered setL of qualitative valuesL={L0, L1, L2, . . . , Ln, Ln+1}.

The qualitative addition and multiplication of linguistic labels, which are commutative, associative, and unitary operators, are defined as follows - see Chapter 10 in [4] for details and examples : 
- Addition : if i + j < n + 1, Li + Lj = Li+j **otherwise** Li + Lj = Ln+1. 

arXiv:0709.0522v1 [cs.AI] 4 Sep 2007 1