
## 4.1 Shafer'S Conditioning Rule (Scr)

Until very recently, the most commonly used conditioning rule for belief revision was the one proposed by Shafer
[2] and referred here as Shafer's Conditioning Rule (SCR). The SCR consists in combining the prior bba m(.) with a specific bba focused on A with Dempster's rule of combination for transferring the conflicting **mass to** non-empty sets in order to provide the revised bba. In other words, the conditioning by a proposition A**, is** obtained by SCR as follows :

$$m_{S C R}(.|A)=[m\oplus m_{S}](.)$$
mSCR(.|A) = [m ⊕ mS](.) (1)
where m(.) is the prior bba to update, A is the conditioning event, mS(.) is the bba focused on A **defined by** mS(A) = 1 and mS(X) = 0 for all X 6= A and ⊕ **denotes the Dempster's rule of combination [2].**
The SCR approach based on Dempster's rule of combination of the prior bba with the bba focused on the conditioning event remains subjective **since actually in such belief revision process both sources are subjective** and SCR doesn't manage properly the objective nature/absolute truth carried by the conditioning term. Indeed, when conditioning a prior mass m(.), knowing (or assuming) that the truth is in A**, means that we have in hands** an absolute (not subjective) knowledge, i.e. the truth in A **has occurred (or is assumed to have occurred), thus** A is realized (or is assumed to be realized) and this is (or at least must be **interpreted as) an absolute truth. The**
conditioning term "Given A" must therefore be considered as an absolute truth, while mS(A**) = 1 introduced**
in SCR cannot refer to an absolute truth actually, but only to a subjective certainty **on the possible occurrence** of A **from a** virtual **second source of evidence. The advantage of SCR remains undoubtedly in its simplicity** and the main argument in its favor is its coherence with conditional probability when manipulating Bayesian belief assignment. But in our opinion, SCR should better be interpreted as the fusion of m(.**) with a particular**
subjective bba mS(A**) = 1 rather than an objective belief conditioning rule. This fundamental remark motivated**
us to develop a new family of BCR [4] based on hyper-power set decomposition (HPSD) explained briefly in the next section. It turns out that many BCR are possible because the **redistribution of masses of elements outside** of A (the conditioning event) to those inside A can be done in n**-ways. This will be briefly presented right after** the next section.

## 4.2 Hyper-Power Set Decomposition (Hpsd)

Let Θ = {θ1, θ2, . . . , θn}, n ≥ 2, a model M**(Θ) associated for Θ (free DSm model, hybrid or Shafer's model)**
and its corresponding hyper-power set DΘ. Let's consider a (quantitative) basic belief assignment (bba) m(.) :
DΘ 7→ [0, 1] such that PX∈DΘ m(X) = 1. Suppose one finds out that the truth is in the set A ∈ DΘ \ {∅}**. Let**
PD(A) = 2A ∩ DΘ \ {∅}, i.e. all non-empty parts (subsets) of A which are included in DΘ**. Let's consider the**
normal cases when A 6= ∅ and PY ∈PD(A) m(Y ) > 0. For the degenerate case when the truth is in A = ∅**, we**
consider Smets' open-world, which means that there are other hypotheses Θ′ = {θn+1, θn+2**, . . . θ**n+m}, m ≥ 1, and the truth is in A ∈ DΘ′\ {∅}. If A = ∅ **and we consider a close-world, then it means that the problem**
is impossible. For another degenerate case, when PY ∈PD(A) m(Y **) = 0, i.e. when the source gave us a totally**
(100%) wrong information m(.), then, we define: m(A|A) , 1 and, as a consequence, m(X|A**) = 0 for any**
X 6= A. Let s(A) = {θi1
, θi2
, . . . , θip }, 1 ≤ p ≤ n, be the singletons/atoms that compose A **(for example, if**
A = θ1 ∪ (θ3 ∩ θ4) then s(A) = {θ1, θ3, θ4}). The Hyper-Power Set Decomposition (HPSD) of DΘ \ ∅ **consists**
in its decomposition into the three following subsets generated by A:
- D1 = PD(A), the parts of A **which are included in the hyper-power set, except the empty set;**

- D2 = {(Θ \ s(A)), ∪, ∩} \ {∅}, i.e. the sub-hyper-power set generated by Θ \ s(A) under ∪ and ∩**, without**
the empty set.

- D3 = (DΘ \ {∅}) \ (D1 ∪ D2); each set from D3 has in its formula singletons from both s(A**) and Θ** \ s(A)
in the case when Θ \ s(A**) is different from empty set.**
D1, D2 and D3 have no element in common two by two and their union is DΘ **\ {∅}**.

Simple example of HPSD: Let's consider Θ = {θ1, θ2, θ3} **with Shafer's model (i.e. all elements of Θ are exclusive)**
and let's assume that the truth is in θ2 ∪ θ3, i.e. the conditioning term is θ2 ∪ θ3. Then one has the following