can be interpreted as a statement composed of a subject, a predicate, and an object. The subject i is related to the object j by the predicate ω.

For instance, a scholarly network can be represented as an RDF network where an article cites an article, an author collaborates with an author, and an author is affiliated with an institution. Because edges are qualified, a heterogeneous set of elements can interact in multiple different ways within the same RDF network representation. It is the labeled edge that makes the Semantic Web and the semantic network, in general, an appropriate data model for systems that require this level of description.

In an RDF network, elements (i.e. vertices, nodes) are called resources and resources are identified by Uniform Resource Identifiers (URI) [1]. The purpose of the URI is to provide a standardized, globally-unique naming convention for identifying any type of resource, where a "resource" can be anything (e.g. physical, virtual, conceptual, etc.). The URI allows every vertex and edge label in a semantic network to be uniquely identified such that RDF networks from disparate organizations can be unioned to form larger, and perhaps more complete, models. The Semantic Web can span institutional boundaries to support a world-scale model. The generic syntax for a URI is
<scheme name> : <hierarchical part> [ \# <fragment> ]
Examples of entities that can be denoted by a URI include:
- a physical object (e.g. http://www.lanl.gov/people\#marko) - a physical component (e.g. http://www.lanl.gov/people\#markos arm) - a virtual object (e.g. http://www.lanl.gov/index.html) - an abstract class (e.g. http://www.lanl.gov/people\#Human).

Even though each of the URIs presented above have an http schema name, only one is a Uniform Resource Locator (URL) [9] of popular knowledge: namely, http://www.lanl.gov/index.html. The URL is a subclass of the URI. The URL is an address to a particular harvestable resource.

While URIs can point to harvestable resources, in general, it is best to think of the URI as an address (i.e. pointer) to a particular concept. With respects to the previously presented URIs, Marko, his arm, and the class of humans are all concepts that are uniquely identified by some prescribed globally-unique URI.

Along with URI resources, RDF supports the concept of a literal.

Example literals include the integer 1, the string "marko", the float (or double) 1.034, the date 2007-11-30, etc. Refer to the XML Schema and Datatypes (XSD) specification for the complete classification of literals
[3].

If U is the set of all URIs and L is the set of all literals, then an RDF
network (or the Semantic Web in general) can be formally defined as1 G ⊆ hU × U × (U ∪ L)i. (1)
To ease readability and creation, schema and hierarchies are usually prefixed (i.e. abbreviated). For example, in the following two triples, lanl is the prefix for http://www.lanl.gov/people\#:
1Note that there also exists the concept of a blank node (i.e. anonymous node). Blank nodes are important for creating n-ary relationships in RDF networks. Please refer to the official RDF specification for more information on the role of blank nodes.