
## 3 Extension Of Dsmt For Qualitative Beliefs

In order to compute with words (i.e. linguistic labels) and qualitative belief assignments instead of quantitative belief assignments2 over GΘ**, Smarandache and Dezert have defined in [14] a** qualitative basic belief assignment qm(.) as a mapping function from GΘ into a set of linguistic labels L = {L0,L, L ˜n+1} where L˜ = {L1, · · · , Ln} is a finite set of linguistic labels and where n ≥ 2 is an integer. For example, L1 **can take the linguistic value "poor",**
L2 the linguistic value "good", etc. L˜ is endowed with a total order relationship ≺, so that L1 ≺ L2 **≺ · · · ≺** Ln.

To work on a true closed linguistic set L **under linguistic addition and multiplication operators, Smarandache**
and Dezert extended naturally L˜ with two extreme values L0 = Lmin and Ln+1 = Lmax, where L0 **corresponds**
to the minimal qualitative value and Ln+1 **corresponds to the maximal qualitative value, in such a way that**
L0 ≺ L1 ≺ L2 ≺ · · · ≺ Ln ≺ Ln+1, where ≺ **means inferior to, or less (in quality) than, or smaller than, etc.** Labels L0, L1, L2, . . . , Ln, Ln+1 **are said** linguistically equidistant if: Li+1 −Li = Li−Li−1 for all i = 1, 2**, . . . , n** where the definition of subtraction of labels is given in the sequel by (11). In the sequel Li ∈ L **are assumed**
linguistically equidistant3labels such that we can make an isomorphism between L = {L0, L1, L2, . . . , Ln, Ln+1}
and {0, 1/(n + 1), 2/(n + 1), . . . , n/(n + 1), 1}, defined as Li = i/(n + 1) for all i = 0, 1, 2, . . . , n, n **+ 1. Using**
this isomorphism, and making an analogy to the classical operations of real numbers, we are able to define the following qualitative operators (or q**-operators for short):**
- q**-addition of linguistic labels**

$$L_{i}+L_{j}=\frac{i}{n+1}+\frac{j}{n+1}=\frac{i+j}{n+1}=L_{i+j}\tag{1}$$

but of course we set the restriction that i+j < n+1; in the case when i+j ≥ n**+1 we restrict** Li+j = Ln+1.

So this is the justification of the qualitative addition we have defined.

- q**-multiplication of linguistic labels**4

Since $L_i\times L_j=\frac{i}{n+1}\cdot\frac{j}{n+1}=\frac{(i\cdot j)/(n+1)}{n+1}$, this means the closest integer to $x$, i.e. 
n+1 , the best approximation would be L[(i·j)/(n+1)]**, where [**x]

$$L_{i}\times L_{j}=L_{[(i\cdot j)/(n+1)]}$$
Li × Lj = L[(i·j)/(n+1)] (6)
For example, if we have L0, L1, L2, L3, L4, L5, corresponding to respectively 0, 0.2, 0.4, 0.**6, 0**.8, 1, then L2 · L3 = L[(2·3)/5] = L[6/5] = L[1.2] = L1; using numbers: 0.4 · 0.6 = 0.24 ≈ 0.2 = L1**; also** L3 · L3 = L[(3·3)/5] = L[9/5] = L[1.8] = L2; using numbers 0.6 · 0.6 = 0.36 ≈ 0.4 = L2.

b) A simpler approximation of the multiplication, but less accurate (as **proposed in [14]) is thus**

$$\left(7\right)$$
$L_i\times L_j=L_{\min\{i,j\}}$. 
Li × Lj = Lmin{i,j} (7)
- **Scalar multiplication of a linguistic label**
Let a **be a real number. We define the multiplication of a linguistic label by a scalar as follows:**

$$a\cdot L_{i}={\frac{a\cdot i}{n+1}}\approx{\begin{cases}L_{[a\cdot i]}&{\mathrm{if~}}[a\cdot i]\geq0,\\ L_{-[a\cdot i]}&{\mathrm{otherwise.}}\end{cases}}$$
$$({\mathfrak{s}})$$

- **Division of linguistic labels**

$$\left(5\right)$$
