We use the fitness cloud **(FC) standpoint, first introduced in [34] by V´erel**
and coworkers. The fitness cloud relative to the local search operator op is the conditional bivariate probability density Pop(Y = ˜ϕ | X = ϕ**) of reaching**
a solution of fitness value ˜ϕ from a solution of fitness value ϕ **applying the**
operator op**. To visualize the fitness cloud in two dimensions, we plot the**
scatterplot F C = {(ϕ, ϕ˜) | Pop(ϕ, ϕ˜) 6= 0}.

In general, the size of the search space does not allow to consider all the possible individuals, when trying to draw a fitness cloud. Thus, we need to use samples to estimate it. We prefer to sample the space according **to a**
distribution that gives more weight to "important" values in the space, for instance those at a higher fitness level. This is also the case of any biased searcher such as an evolutionary algorithm, simulated annealing and **other** heuristics, and thus this kind of sampling process more closely simulates the way in which the program space would be traversed by a searcher. So, we use the Metropolis-Hastings technique [35] to sample the search space.

The Metropolis-Hastings sampling technique is an extension of the Metropolis algorithm to non-symmetric stationary probability distributions. It **can be**
defined as follows. Let α **be the function defined as:**

$$\alpha(x,y)=m i n\{1,\frac{y}{x}\},$$

and f(γk) be the fitness of individual γk. A sample of individuals {γ1, γ2**, . . . , γ**n}
is built with the algorithm shown in figure 2.

In order to algebraically extract some information from the fitness **cloud, in** [36,37], we have defined a measure, called negative slope coefficient (nsc**). The**
abscissas of a scatterplot can be partitioned into m segments {I1, I2**, . . . , I**m}
with various techniques. Analogously, a partition of the ordinates {J1, J2**, . . . ,**
Jm} can be done, where each segment Ji contains all the ordinates corresponding to the abscissas contained in Ii. Let M1, M2, . . . , Mm be the averages of the abscissa values contained inside the segments I1, I2, . . . , Im **and let**
N1, N2, . . . , Nm be the averages of the ordinate values in J1, J2, . . . , Jm**. Then**
we can define the set of segments {S1, S2, . . . , Sm−1}, where each Si **connects**
the point (Mi, Ni) to the point (Mi+1, Ni+1**). For each one of these segments**
Si, the slope Pi **can be calculated as follows:**

$$P_{i}={\frac{N_{i+1}-N_{i}}{M_{i+1}-M_{i}}}$$
