The notion of neutrality has been suggested by Kimura [20] in his study of the evolution of molecular species. According to this view, most mutations are neutral (their effect on fitness is small) or lethal. In the analysis of fitness landscapes, the notion of neutral mutation appears to be useful [21]. Let us thus define more precisely the notion of neutrality for fitness landscapes.

Definition: A test of neutrality is a predicate isNeutral : S × S → {**true,**
f alse} that assigns to every (s1, s2) ∈ S
2the value true **if there is a small**
difference between f(s1**) and** f(s2). For example, usually isNeutral(s1, s2) is true if f(s1) = f(s2**). In that case,** isNeutral is an equivalence relation. Other useful cases are isNeutral(s1, s2)
is true if |f(s1) − f(s2)| ≤ 1/M with M **is the population size. When** f is stochastic, isNeutral(s1, s2) is true if |f(s1) − f(s2)| **is under the evaluation**
error.

Definition: For every s ∈ S, the neutral neighborhood of s is the set Nneut(s) =
{s
′

∈ N(s) | isNeutral(**s, s**
′
)} and the neutral degree of s, noted nDeg(s**) is**
the number of neutral neighbors of s, nDeg(s) = ♯(Nneut(s) − {s}).

A fitness landscape is neutral if there are many solutions with high neutral degree. In this case, we can imagine fitness landscapes with some plateaus called neutral networks**. Informally, there is no significant difference of fitness** between solutions on neutral networks and the population drifts around on them.

Definition: A neutral walk Wneut = (s0, s1, . . . , sm**) from** s to s
′
**is a walk**
from s to s
′
where for all (i, j) ∈ [0, m]
2, isNeutral(si, sj ) is **true**.

Definition: A Neutral Network, denoted NN, is a graph G = (V, E**) where**
the set V of vertices is the set of solutions belonging to S **such that for all** s and s
′
from V there is a neutral walk Wneut belonging to V **from** s to s
′
**, and**
two vertices are connected by an edge of E **if they are neutral neighbors.**
Definition: A portal in a NN **is a solution which has at least one neighbor**
with greater fitness.

7