calculating the fitness-distance correlation coefficient (FDC)**. Given a set** F =
{f1, f2, ..., fm} of m **individual fitness values and a corresponding set** D = {d1, d2, ..., dm} of the m **distances to the nearest global optimum, FDC is**
defined as:
 $$FDC=\frac{C_{FD}}{\sigma_{F}\sigma_{D}}$$  $$C_{FD}=\frac{1}{m}\sum_{i=1}^{m}(f_{i}-\overline{f})(d_{i}-\overline{d})$$ $$\text{l.D.}\to\text{l.}\qquad\quad\overline{f}\to\text{l.}\overline{d}\to\text{l.}$$
where:
is the covariance of F and D and σF , σD, f and d **are the standard deviations**
and means of F and D. Thus, by definition, FDC ∈ [−1, **1]. As we hope that**
fitness increases as distance to a global optimum decreases (for maximization problems), we expect that, with an ideal fitness function, FDC will assume the value of −**1. According to Jones [19], GA problems can be classified in**
three classes, depending on the value of the FDC coefficient:

- Misleading (F DC ≥ 0.**15), in which fitness increases with distance.** - Difficult (−0.15 < F DC < 0.**15) in which there is virtually no correlation**
between fitness and distance.

- Straightforward (F DC ≤ −0.**15) in which fitness increases as the global**
optimum approaches.
The second class corresponds to problems for which the FDC coefficient does not bring any information. The threshold interval [−0.15, 0.**15] has been empirically determined by Jones. When FDC does not give a clear indication**
i.e., in the interval [−0.15, 0.**15], examining the scatterplot of fitness versus**
distance can be useful. The FDC has been criticized on the grounds that counterexamples can be constructed for which the measure gives wrong results [27,28,29]. Another drawback of FDC is the fact that it is not a predictive **measure since it requires knowledge of the optima. Despite its shortcomings, we use FDC here**
as another way of characterizing problem difficulty because we know **some**
optima and we predict whether or not it is easy to reach those local optima.

## 3.3.4 The Autocorrelation Function And The Box-Jenkins Approach

Weinberger [30,31] introduced the autocorrelation function and the correlation length of random walks to measure the correlation structure of fitness landscapes. Given a random walk (st, st+1, . . .), the autocorrelation function ρ of a fitness function f **is the autocorrelation function of time series**
(f(st), f(st+1), . . .) :

$$\rho(k)=\frac{E[f(s_{t})f(s_{t+k})]-E[f(s_{t})]E[f(s_{t+k})]}{v a r(f(s_{t}))}$$
