
## 2.1 Whole Fitness Cloud

We draw scatterplot, the so-called whole fitness cloud including, for each string of the search space, all the points in the hamming neighborhood (see fig.1). As the density of points on the scatterplot gives little information on dispersion, a standard deviation is plotted on both side of the **mean** curve.

![0_image_0.png](0_image_0.png) 

Figure 1. The whole fitness cloud of NK-landscape with N = 25 and K = 20: the fitness cloud (F C) and it shape (F Cmin, F Cmax and F C**mean** with standart-deviation) under the hamming neighborhood. The F C**mean** curve is roughly a line.

The fact that the F C**mean** curve computing on the whole scatterplot is roughly a line (see fig.1) confirms the results from Weinberger
[3]: ˜f**mean** =1 −
K+1 N
f + K+1 N
0.5 As reported by [1], let us note that the slope coefficient 1 −
K+1 Nis the offspring-parent fitnesses correlation.

## 2.2 Hill Climbing

A greedy hill climbing heuristic (so-called GHC) is used.

![0_image_1.png](0_image_1.png) 

## 2.2.1 Fc, Local Optima And Epistasis

A local optimum is a point in the landscape which is higher than any of the points which immediately surround it. For such a point, the best possible fitness over its neighbourhood is less fit than it; so, its bordering fitness is lower than its fitness. Within the cloud, local optima fit points under the diagonal line (see fig. 2). Such a localization gives insight on the amount and the fitnesses of local optima.

Examining the fitness cloud, the set F C**mean** seems to be coarsely supported by a line (see fig. 2). As for the whole fitness cloud, we can prove that F C**mean** is a line with the same slope of 1−
K+1 Nand the Y-intercept is a constant which depends on N and K.

## 2.2.2 Dynamics On The Fitness Cloud Under Ghc

We conjecture that the β fitness level is a *barrier of fitness*. This means that, applying GHC heuristic from a random initial solution, on average the search process breaks off around β. To validate this hypothesis we conduct a number of experiments on the NK-landscape with GHC: the search heuristic is run over 100 generations to collect information on the dynamics as the list of successive points (f, ˜f) encountered during the search process. All the experimental datas collected from 70 such runs allows to build an *average trajectory*. As expected this trajectory starts on the F C**mean** line with a fitness near to 0.5 4, and then roughly follows the F C**mean** line to finally breaks off around the (β; β) point (see fig. 2). Therefore, examining the fitness cloud allows to predict the average long-term behavior for GHC at fitness level.

## Conclusion

In this paper we have presented the *Fitness Cloud* as a complementary viewpoint to the *Fitness Landscape* metaphor. FC is a 2-d representation where the topology induced by an heuristic is directly taken into account. Our analytical and empirical results suggest that FC allows us to characterize the set of local optima and barriers of fitness too. In others experiments on Simulated Annealing, we have established that FC can predict the barriers of fitness. In such a context, we believe the FC can be used beneficially to track the dynamic and to predict the average behavior of the search process. To change the metaphor from landscape to cloud leads change to the picture from that of a point getting stuck on a local peak to that of a point pulled towards a particular set of neutrality.

## References

[1] Smith, Husbands, Layzell, and O'Shea, 'Fitness landscapes and evolvability', *Evolutionary Computation*, 1(10), 1–34, (2001). [2] G. P. Wagner and L. Altenberg, 'Complexes adaptations and the evolution of evolvability', in *Evolution*, pp. 967–976, (1996).

[3] E. D. Weinberger, 'Correlated and uncorrelatated fitness landscapes and how to tell the difference', in *Biological Cybernetics*, pp. 63:325–336,
(1990).

[4] S. Wright, 'The roles of mutation, inbreeding, crossbreeding, and selection in evolution', in Proceedings of the Sixth International Congress of Genetics 1, pp. 356–366, (1932).