# Measuring The Evolvability Landscape To Study Neutrality

S. Verel Univ. of Nice-Sophia Antipolis 2000, route des Lucioles Sophia, France verel@i3s.unice.fr

## Abstract

This theoretical work defines the measure of **autocorrelation** of evolvability **in the context of neutral fitness landscape.**
This measure has been studied on the classical MAX-SAT
problem. This work highlight a new characteristic of neutral fitness landscapes which allows to design new adapted metaheuristic.

## Categories And Subject Descriptors

I.2.8 [**Problem Solving, Control Methods, and Search**]: Heuristic methods—**fitness landscapes, neutrality, measures**

## General Terms Theory Introduction

Fitness landscape, introduce by Wright [4] in evolutionary biology, is one of the powerful metaphor to model evolutionary process. The dominant view in this metaphor is an adaptive evolution where an uphill walk of a population on a mountainous fitness landscape in which it can get stuck on suboptimal peaks. In combinatorial optimization, this view also influence the design of metaheuristic: the geometry of multimodality or ruggedness describes the fitness landscape and the metaheuristics try to escape from local optima by using a probability to explore the landscape in simulated annealing, by using a memory in tabu search, or by preserving the diversity of population in evolutionary algorithm.

Another geometry of fitness landscapes, enlightened in molecular evolution by Kimura [2], takes an important place in optimization: the neutral fitness landscape. In the theory of neutral evolution, the overwhelming majority of mutations are either effectively neutral or lethal and in the latter case purged by negative selection. According to this theory, fitness landscapes are dominated by plateaus, called neutral networks**. The landscapes from genetic programming or from applicative problems such as minimal linear**
arrangement are known to be neutral. It is difficult to decide whether neutrality is useful for optimization. This work propose to deeper describe neutral fitness landscapes in order to get some characteristics of theses problems and obtain a more complete view on neutrality which allows to design more useful metaheuristic.

Copyright is held by the author/owner(s). GECCO'06, July 8–12, 2006, Seattle, Washington, USA. ACM 1-59593-186-4/06/0007.

P. Collard Univ. of Nice-Sophia Antipolis 2000, route des Lucioles Sophia, France pc@i3s.unice.fr M. Clergue Univ. of Nice-Sophia Antipolis 2000, route des Lucioles Sophia, France clerguem@i3s.unice.fr

## 1. Fitness Landscapes

We will use the definition of fitness landscapes from [4].

A fitness landscape is a triplet (S,V, f) such as: S **is the**
set of potential solutions, V : S → 2 S
**is the neighborhood**
function which associated to each solution s ∈ S **a set of**
neighbor solutions V(s) ⊂ S, and f : S → **IR is the fitness**
function which associates a real number to each solution.

## 1.1 Rugged Fitness Landscapes

Weinberger [6] introduced the autocorrelation function and the correlation length of random walks to measure the ruggedness of fitness landscapes.

Given a random walk (st, st+1, . . .), the autocorrelation function ρ of a fitness function f **is the autocorrelation function**
of time series (f(st), f(st+1), . . .) :

## Ρ(K) = E[F(St)F(St+K)] − E[F(St)]E[F(St+K)] Var(F(St))

where E[f(st)] and var(f(st**)) are the expected value and**
the variance of f(st**). The correlation length** τ = −1 log(ρ**(1))** ,
measures how the autocorrelation function decreases and it summarizes the ruggedness of the landscape: the larger the correlation length, the smoother is the landscape.

## 1.2 Neutral Fitness Landscapes

The geometry of neutral fitness landscapes are based on the concept of neutral neighborhood and neutral networks.

For every s ∈ S, the neutral neighborhood of s **is the set**
Vneut(s) = {s
′

∈ V(s) | f(s) = f(s
′

)} and the neutral degree of s is the number of neutral neighbors of s**. There**
is no exact definition of neutral fitness landscape but we can define a fitness landscape as neutral if there are "many" solutions with "high" neutral degree. In this case, we can imagine fitness landscapes with some plateaus called neutral networks**. There is no significant difference of fitness**
between solutions on neutral networks and the population drifts around on them.

The Neutral Networks (NN) of a fitness landscape are connected graphs which are the connected components of graph (S,Vneut**). Solutions in a NN have the same fitness**
value and there is a path of neutral neighbors between two solutions of a NN. The presence of NN takes place in the search dynamic. For example, the time of drift on NN during the search process depends on the properties of the networks.