4) Co-reference relations. This feature is useful to recognize co-references. In the medical domain, demonstrative noun phrases ("dans ce cas", "in this case...".) is the most common way of marking co-reference. We then used data mining algorithms (in particularly attributes selectors and rules learning algorithms) in order to statistically validate the potential interest of the different features, understand their relative contribution and derive the set of structuring rules.

## 3.2 The Rules Organized In Knowledge Levels

One of the main result of our study is that features related to the material structure of the text are the most discriminating ones for the task, using an "Information Gain" measure.

First, the location of the condition in the sentence (detached or not) is especially important. If it is detached, it exerts in 70% of the cases an influence downward from the sentence in which it is located. Conversely, if the condition is integrated inside the sentence, its scope is limited to the sentence boundaries in 80 % of the cases. More generally, the scope of a conditional segment often complies with the material text structure. Thus, the rules which involve these features correspond to **norms**. This can be explained by the style of writing used for the "guidelines" text genre, that often makes use of visual information. The other kinds of attributes (discourse connectors, lexical relations co-coreference informations) are less discriminating simply because they are less frequent. Nevertheless, they are sometimes important since they may violate a norm and suggest a more accurate way of structuring the document. The rules which involve these features are called **exceptions**. Therefore, we have organized the structuring rules according the ability of a feature to contribute to the solution (norms vs. exceptions). The **norms** represent the most discriminating rules and involve the most salient features which belong to the category of the material text structure.

 By default, IF c is syntactically integrated AND s is in another sentence of c THEN s is excluded from the scope of c. Conversely, IFc is syntactically integrated AND s is in the sentence of c THEN s is under the scope of c.

 By default, IF c is detached from the sentence AND s is in the same position in the material structure than c THEN s is excluded from the scope of c. Conversely, IF s is in the same position in the material structure than c AND s and c are in the same paragraph THEN s is included in the scope of c.
These two rules can be violated if another set of rules called **exceptions** suggest a more accurate way of structuring the text. A first set of rules suggest an inclusion of s under the scope of c. For example, the following rule belongs to this category:
 IF s is in a co-reference relation with c THEN s is under the scope of c.

Conversely, some other rules suggest an exclusion of s. For example:
 IF s is preceded by a discourse coordination connector THEN s is excluded from the scope of c.