the grid. Alternatively, we could break up the 2D grid into a set of width 2 vertical strips, as discussed previously.

Now, the procedure is essentially the same as before. We start with the equivalent constrained optimization problem defined on the augmented graph, now subject to both in-scale and cross-scale constraints. We obtain a tractable problem by introducing Lagrange multipliers to relax these constraints. Then we iteratively adjust the Lagrange multipliers to minimize the dual function, with the aim of eliminating constraint violations to obtain the desired MAP estimate. This is equivalent to adjusting the augmented model f
′(x
′)
on G
′, subject to the constraint that it remains equivalent to f(x) for all x
′ = Ax.

## B. Gaussian Multiscale Moment-Matching

We demonstrate this approach in the Gaussian model. To carry out the minimization, we again use a block coordinatedescent method that finds an exact minimum over a subset of Lagrange multipliers at each step. The replica constraints are handled the same as before. Here, we briefly summarize our approach to handle the cross-scale summary constraints. Let x1 and x2 denote two random vectors at consecutive scales coupled by the constraint x2 = Ax1. Let (hˆ1,Jˆ1) and (hˆ2,Jˆ2)
denote their corresponding *marginal* information parameters.

Relaxing the constraints x2 = Ax1 and x2x T
2 = Ax1x T
1 A
T,
with Lagrange multipliers (λ,−
1 2 Λ), leads to the following optimality conditions:

$$(\hat{J}_{2}+\Lambda)^{-1}=A(\hat{J}_{1}-A^{T}\Lambda A)^{-1}A^{T}\tag{36}$$ $$(\hat{J}_{2}+\Lambda)^{-1}(\hat{h}_{2}+\lambda)=A(\hat{J}_{1}-A^{T}\Lambda A)^{-1}(\hat{h}_{1}-A^{T}\lambda)$$  We find that the solution is:
We find that the solution is.  $$\Lambda=\frac{1}{2}\{(A\hat{J}_{1}^{-1}A^{T})^{-1}-\hat{J}_{2}\}$$ $$\lambda=\frac{1}{2}\{(A\hat{J}_{1}^{-1}A^{T})^{-1}A\hat{J}_{1}^{-1}\hat{h}_{1}-\hat{h}_{2}\}\tag{37}$$  The model $(h^{\prime},J^{\prime})$ is then updated by adding $(\lambda,\Lambda)$ to 
the coarse-scale and subtracting (A
T λ,A
TΛA) from the fine scale. This update enforces the moment conditions ˆx2 = Axˆ1 and P2 = AP1A
T while maintaining consistency of the model (h
′,J
′). Similar updates can be derived when there are multiple replicas of x1 and x2. These methods, together with those described previously, are used to minimize the dual function in the Gaussian multiscale relaxation.

Multiscale Example. We provide a preliminary result involving a 1D thin-membrane model with 1024 nodes. It is defined to have a long correlation length comparable to the length of the field. Using a random h-vector, we solve for the MAP estimates using three methods: a standard block Gauss-Seidel iteration using overlapping blocks of size 4; the (single-scale) Gaussian LR method with the same choice of blocks; and the multiscale LR method. The convergence of all three methods are shown in Fig. 8. We see that the single-scale LR approach is moderately faster than block Gauss-Seidel, but introducing coarser-scales into the method leads to a significant speed-up in the rate of convergence.

4The formula (37) corresponds to a generalization of Algorithm 2, in which the moments (xˆ1,P1) of fine-scale variables x1 are replaced by the corresponding moments (Axˆ1,APˆ1A
T) of the summary statistic ˜x1 = Ax1.

![0_image_0.png](0_image_0.png)

We have introduced a general Lagrangian relaxation framework for MAP estimation in both discrete and Gaussian graphical models. This provides a new interpretation of some existing methods, provides deeper insights into those methods, and leads to new generalizations, such as the multiscale relaxation introduced here. There are many promising directions for further work. While we have considered discrete and Gaussian models separately, the basic approach should extend to the richer class of conditionally Gaussian models [1] including both discrete and continuous variables.

In discrete models, designing augmented models that capture more structure of the original problem leads to reduced duality gaps and optimal MAP estimates in larger classes of models. It would be of great interest to finds ways to adaptively search this hierarchy of relaxations to efficiently reduce and eventually eliminate the duality gap with minimal computation. It is also of interest to consider approaches to identity provably *near-optimal* estimates, perhaps using the relaxed max-marginal estimates, in cases where it is not tractable to completely eliminate the duality gap.

## References

[1] S. Lauritzen. *Graphical Models*. Oxford Univ. Press, 1996. [2] R. Cowell, A. Dawid, S. Lauritzen, and D. Spiegelhalter. Probabilistic Networks and Expert Systems. Springer-Verlag, 1999.

[3] B. Frey, editor. *Graphical models for machine learning and digital* communication. MIT Press, 1998.

[4] M. Wainwright and M. Jordan. Graphical models, exponential families, and variational inference. Technical Report 649, Dept. of Stat., UC Berkeley, 2003.

[5] A. Dempster. Covariance selection. *Biometrics*, 28(1), March 1972. [6] T. Speed and H. Kiiveri. Gaussian Markov distributions over finite graphs. *Annals Stat.*, 14(1), March 1986.

[7] D. Bertsekas. *Nonlinear Programming*. Athena Scientific, 1995. [8] D. Bertsimas and J. Tsitsiklis. *Linear Opitimization*. Athena Scientific, 1997.

[9] M. Wainwright, T. Jaakkola, and A. Willsky. MAP estimation via agreement on (hyper)trees: Message-passing and linear-programming approaches. *IEEE Trans. Information Theory*, November 2005.

[10] V. Kolmogorov and M. Wainwright. On the optimality of treereweighted max-product message passing. In *Proc. Conf. Uncertainty* in AI, July 2005.

[11] J. Feldman, M. Wainwright, and D. Karger. Using linear programming to decode binary linear codes. *IEEE Trans. Information Theory*, 51, March 2005.

[12] C. Yanover, T. Meltzer, and Y. Weiss. Linear programming relaxations and belief propagation. *J. Machine Learning Research*, 7, 2006.

[13] T. Werner. A linear programming approach to max-sum, a review.

IEEE Trans. Pattern Analysis and Machine Intelligence, July 2007.

[14] S. Boyd and L. Vandenberghe. *Convex Optimization*. Cambridge University Press, 2004.