ALGORITHM 1 (Discrete LR)
Iterate until convergence:
For $E\in\mathscr{G}$ where $r_{E}>1$  For $E^{\prime}\in\mathscr{R}(E)$  $\hat{f}_{\tau,E^{\prime}}(x^{\prime}_{E^{\prime}})=\tau\log p_{\tau,\lambda}\left(x^{\prime}_{E^{\prime}}\right)$  end  $\hat{f}_{\tau,E}(x_{E})=r_{E}^{-1}\sum_{E^{\prime}}\hat{f}_{\tau,E^{\prime}}(x_{E})$  For $E^{\prime}\in\mathscr{R}(E)$  $f_{E^{\prime}}(x_{E})\leftarrowf_{E^{\prime}}(x_{E})+\left(\bar{f}_{\tau,E^{\prime}}(x_{E})-\hat{f}_{\tau,E^{\prime}}(x_{E})\right)$  end
g(λ;τ) is computed as:

$$\begin{array}{lcl}\partial g(\lambda;\tau)&=&\frac{\partial\Phi_{\tau}}{\partial\theta^{\prime}_{A}}\frac{\partial\theta^{\prime}_{A}}{\partial\lambda_{A,B}}+\frac{\partial\Phi_{\tau}}{\partial\theta^{\prime}_{B}}\frac{\partial\theta^{\prime}_{B}}{\partial\lambda_{A,B}}\\ &=&p_{\lambda,\tau}[\phi_{A}]-p_{\lambda,\tau}[\phi_{B}]\end{array}\tag{22}$$

where we use p[·] to denote expectation under p. Thus, appealing to strict convexity, there is a unique λ
∗(τ) that minimizes g(λ;τ) and it is also the unique solution of the set of moment-matching conditions:

## Pλ,Τ[Φa] = Pλ,Τ[Φb], For All A ≡ B.

These moment-matching conditions are equivalent to requiring that the marginal distributions pλ,τ(xA) and pλ,τ(xB)
are equal for xA = xB. We also note that ∂g(λ;τ)
∂τ =
pλ,τ[−log pλ,τ], which is the *entropy* of pλ,τ and is positive for all λ. Hence, for a decreasing sequence τk > 0 converging to zero, g(λ;τ) converges *monotonically* to g(λ). Likewise, g
∗(τk) converges *monotonically* to g
∗.

Rather than directly optimizing g(λ), we instead perform a sequence of minimizations with respect to the functions g(λ;τk). At each step, the previous estimate of λ
∗
k =
argming(λ;τk) is used to initialize an iterative method to minimize g(λ;τk+1). This is illustrated in Fig. 4. At each step, we use the following optimization procedure based on the marginal agreement condition.

1) Iterative Log-Marginal Averaging: To minimize g(λ;τ) for a specified τ, starting from an initial guess for λ (or, equivalently, an initial splitting of f), we develop a block coordinate-descent method. Our approach is in the same spirit as the iterative proportional fitting procedure [15].

We begin with the case that the augmented model is defined so that no two replicas of a node are contained in the same connected component of G
′. Then, at each step, we minimize over the set of all Lagrange multipliers associated with features defined within any replica of E. This is equivalent to solving the condition that the corresponding marginal distributions pλ,τ(x
′
E′) are consistent for all E
′ ∈
R(E). Algorithm 1 summarizes the method, which involves computing the log-marginal of each replica edge, and then updates the functions f
′
E′ according to the rule:

$$f^{\prime}_{E^{\prime}}(x_{E})\gets f^{\prime}_{E^{\prime}}(x_{E})+(\tilde{f}_{\tau,E}(x_{E})-\hat{f}_{\tau,E^{\prime}}(x_{E}))\tag{23}$$

where

$$\hat{f}_{\tau,E^{\prime}}(x_{E^{\prime}}^{\prime})=\tau\log p_{\lambda,\tau}(x_{E^{\prime}}^{\prime}),\ \bar{f}_{\tau,E}(x_{E})=r_{E}^{-1}\sum_{E^{\prime}\in\mathcal{R}(E)}\hat{f}_{\tau,E^{\prime}}(x_{E}).$$

After the update, the new log-marginals of all replicas E
′
are equal to ¯fτ,E . Also, these updates maintain a consistent representation: ∑E′(¯fτ,E − ˆfτ,E′) = 0. To handle augmented models with multiple replicas of E in the same connected subgraph, we only update a *subset* of replicas at each step, where no two replicas are in the same subgraph. In some cases, this requires including an extra replica of E to act as an intermediary in the update step.

Each step of the procedure requires that we compute the marginal distributions of each replica E
′in their respective subgraphs. In the graphs are thin, these marginals can be computed efficiently, with computation linear in the size of each subgraph, using standard belief propagations methods and their junction tree variants. Moreover, if we take some care to store the messages computed by belief propagation, it is possible to amortize the cost of this inference, by only updating a few "messages" at each step. In fact, it is only necessary to update those messages along the directed path from the last updated node or edge to the location in the tree (or junction tree) of the node or edge currently being updated. We find that this generally allows a complete set of updates to be computed with complexity linear in n. Similar ideas are discussed in [16].

Using Algorithm 1, together with a rule to gradually reduce τ, we obtain a simple algorithm which generates a sequence λk such that g(λk) converges to g
∗and λk converge to a point in the set of optimal Lagrange multipliers.

2) Iterative Max-Marginal Averaging: We now consider what happens as τ approaches zero. The main insight is that the (non-normalized) log-marginals converge to *maxmarginals* in the limit as τ approaches zero:

$$\hat{f}_{\tau,E^{\prime}}(x^{\prime}_{E^{\prime}})+g(\lambda,\tau)\rightarrow\hat{f}_{E^{\prime}}(x^{\prime}_{E^{\prime}})\stackrel{{\triangle}}{{=}}\max_{x^{\prime}_{\backslash E^{\prime}}}f^{\prime}(x^{\prime}_{E^{\prime}},x^{\prime}_{\backslash E^{\prime}};\lambda)\tag{24}$$

Hence, as τ becomes small, the marginal agreement conditions are similar to a set of *max-marginal agreement* conditions among all replicas of an edge or node. One could consider a "zero-temperature" version of Algorithm 1 aimed at solving these max-marginal conditions directly:

$$\begin{array}{ccccc}f^{\prime}_{E^{\prime}}(x_{E})&\leftarrow&f^{\prime}_{E^{\prime}}(x_{E})+\left(\bar{f}_{E}(x_{E})-\hat{f}_{E^{\prime}}(x_{E})\right)\\ \bar{f}_{E}(x_{E})&=&r^{-1}_{E}\sum_{E^{\prime}}\hat{f}_{E^{\prime}}(x_{E})\end{array}\tag{25}$$

Here, ¯fE is the averaged max-marginal over all replicas of E. Note that ˆfE′(xE) ≥ ˆfE (xE) , maxx\E
f(x) for all xE and E
′ ∈ R(E), which implies ¯fE(xE ) ≥ ˆfE(xE ). This "zerotemperature" approach has close ties to max-sum diffusion
(see [13] and reference therein) and Kolmogorov's serial approach to TRMP [16].

In our framework, one can show that λ
∗ , limτ→0 λ
∗(τ) is well-defined and minimizes g(λ). This point λ
∗also satisfies the max-marginal agreement condition and is therefore a