tic modeling to predict terrorism attacks [Singh (2004)] is relevant practically. The idea of machine learning of latent variables [Silva (2006)] is potentially applicable to discovering an unknown network structure.

## 3 Problem Definition

The node discovery problem is defined mathematically in this section. A node represents a person in a social network. A link represents a relationship which transmits the influence between persons. The symbols nj (j = 0, 1, · · ·**) represent the nodes. Some nodes are**
overt (observable), but the others are covert (unobservable). O denotes the overt nodes; {n0, n1, · · · , nN−1}.

Its cardinality is |O| = N. C = O **denotes the covert**
nodes; {nN , nN+1, · · · , nM−1}**. Its cardinality is** |C| =
M − N**. The whole nodes in a social network is** O ∪ C.

The number of the nodes is M**. The unobservability of**
the covert nodes arises either from a technical defect of surveillance means or an intentional cover-up operation.

The symbol δi **represent a set of participants in a**
particular collaborative activity. It is the i**-th activity**
pattern among the nodes. A pattern δi**is a set of nodes;**
δiis a subset of O ∪ C**. For example, the nodes in**
an collaborative activity pattern are those who joined a particular conference call. That is, a pattern is a co-occurrence among the nodes [Rabbat (2008)]. The unobservability of the covert nodes does not affect the activity patterns themselves.

A simple hub-and-spoke model is assumed as a model of the influence transmission over the links resulting the collaborative activities among the nodes. The way how the influence is transmitted governs the set of possible activity patterns {δi}**. The network topology and**
the influence transmission are described by some probability parameters. The probability where the influence transmits from an initiating node nj to a responder node nk is rjk**. The influence transmits to multiple**
responders independently in parallel. It is similar to the degree of collaboration probability in trust model- P
ing [Lavra˘c (2007)]. The constraints are 0 ≤ rjk and k6=j rjk ≤ 1. The quantity fj **is the probability where**
the node nj **becomes an initiator. The constraints are**
0 ≤ fj and PN−1 j=0 fj **= 1. These parameters are defined**
for the whole nodes in a social network (both the nodes in O and C).

A surveillance log di **records a set of the overt nodes**
in a collaborative activity pattern; δi**. It is given by**
eq.(1). A log diis a subset of O**. The number of data**
is D. A set {di} **is the whole surveillance logs dataset.**

$$d_{i}=\delta_{i}\cap{\cal O}\ (0\leq i<D).$$

di = δi ∩ O (0 ≤ i < D). (1)
Note that neither an individual node nor a single link alone can be observed directly, but nodes can be observed collectively as a collaborative activity pattern.

The dataset {di} **can be expressed by a 2-dimensional**
D × N matrix of binary variables d**. The presence or**
absence of the node nj in the data di**is indicated by the**
elements in eq.(2).

$$\mathbf{d}_{i j}={\left\{\begin{array}{l l}{1}&{{\mathrm{if~}}n_{j}\in d_{i}}\\ {0}&{{\mathrm{otherwise}}}\end{array}\right.}(0\leq i<D,\ 0\leq j<N).\quad(2)$$

Solving the node discovery problem means identifying all the surveillance logs where covert nodes would appear if they became overt. In other words, it means to identifying the logs for which di 6= δi **holds because**
of the covert nodes belonging to C.

## 4 Solution 4.1 Heuristic Method

A heuristic method to solve the node discovery problem is studied in [Maeno (2009)]. The method is reviewed briefly.

At first, every node which appears in the dataset
{di} is classified into one of the clusters cl (0 ≤ **l < C**).

The number of clusters is C**, which depends on the prior**
knowledge. Mutually close nodes form a cluster. The measure of closeness between a pair of nodes is evaluated by the Jaccard's coefficient [Liben-Nowell (2004)]. It is used widely in link discovery, web mining, or text processing. The Jaccard's coefficient between the nodes n and n
′is defined by eq.(3). The function B(s**) in eq.(3)**
is a Boolean function which returns 1 if the proposition s is trueCor 0 otherwise. The operators ∧ and ∨ are logical AND and OR.

$$J(n,n^{\prime})={\frac{\sum_{i=0}^{D-1}B(n\in d_{i}\wedge n^{\prime}\in d_{i})}{\sum_{i=0}^{D-1}B(n\in d_{i}\lor n^{\prime}\in d_{i})}}.\qquad\qquad{\mathrm{(3)}}$$

The k-medoids clustering algorithm [Hastie (2001)]
is employed for classification of the nodes. It is an EM
(expectation-maximization) algorithm similar to the kmeans algorithm for numerical data. A medoid node locates most centrally within a cluster. It corresponds to the center of gravity in the k-means algorithm. The clusters and the modoid nodes are re-calculated iteratively until they converge into a stable structure. The k-medoids clustering algorithm may be substituted by other clustering algorithms such as hierarchical clustering or self-organizing mapping.

Then, suspiciousness of every surveillance log di **as a**
candidate where the covert nodes would appear is evaluated with a ranking function s(di**). The ranking function returns higher value for a more suspicious log. The**
strength of the correlation between the log di **and the**
cluster clis defined by w(di, cl**) in eq.(4) as a preparation.**

$\left(\frac{1}{2}\right)$
$$w(d_{i},c_{l})=\operatorname*{max}_{n_{j}\in c_{l}}{\frac{B(n_{j}\in d_{i})}{\sum_{i=0}^{D-1}B(n_{j}\in d_{i})}}.$$
$$\quad(4)$$

. (4)