clusters appear less frequently as η **increases. The initial links between the clusters are connected at random**

before growth by preferential attachment starts.  $$p(k\to j)\propto\left\{\begin{array}{ll}\eta(C-1)K(n_{j})&\mbox{if}c(n_{j})=c(n_{k})\\ K(n_{j})&\mbox{otherwise}\end{array}\right..\tag{19}$$
Hub nodes are those which have a nodal degree larger than the average. The node n12 **in the network [A] in**
Figure 1 is a typical hub node. Peripheral nodes are those which have a nodal degree smaller than the average. The node n75 **in the network [A] in Figure 1 is a**
typical peripheral node.

The network in Figure 3 represents a real clandestine organization. It is a global mujahedin organization which was analyzed in [Sageman (2004)]. The mujahedin in the global Salafi jihad means Muslim fighters in Salafism (Sunni Islamic school of thought) who struggle to establish justice on earth. Note that jihad does not necessarily refer to military exertion. The organization consists of 107 persons and 4 regional sub-networks.

The sub-networks represent Central Staffs (nCSj ) including the node nObL, Core Arabs (nCAj **) from the**
Arabian Peninsula countries and Egypt, Maghreb Arabs
(nMAj **) from the North African countries, and Southeast**
Asians (nSAj **). The network topology is not simply hierarchical. The 4 regional sub-networks are connected**
mutually in a complex manner.

The node representing Osama bin Laden; nObL **is a**
hub (K(nObL**) = 8). He is believed to be the founder**
of the organization, and said to be the covert leader who provides operational commanders in regional subnetworks with financial support in many terrorism attacks including 9/11 in 2001. His whereabouts are not known despite many efforts in investigation and capture.

The topological characteristics of the above mentioned networks are summarized in Table 1. The global mujahedin organization has a relatively large Gini coefficient of the nodal degree; G = 0.**35 and a relatively large average clustering coefficient [Watts (1998)];**
hW(nj )i = 0.**54. In economics, the Gini coefficient is a**
measure of inequality of income distribution or of wealth distribution. A larger Gini coefficient indicates lower equality. The values mean that the organization possesses hubs and a cluster structure. The values also indicate that the computationally synthesized network [A] is more clustered and close to the global mujahedin organization while the network [B] is less clustered.

## 5.2 Test Dataset

The test dataset {di} **is generated from each network in**
5.1 in the 2 steps below.

In the first step, the collaborative activity patterns
{δi} are generated D **times according to the influence**

![0_image_0.png](0_image_0.png)

Table 1: The number of nodes M**, the number of clusters**
C, the average degree hK(nj )i**, the average clustering** coefficient hW(nj )i, and the Gini coefficient G **of the**
computationally synthesized networks (CSN) [A] and [B], and the global mujahedin organization (GMO).

| Model   | M   | C   | η   | hKi   | hWi   | G    |
|---------|-----|-----|-----|-------|-------|------|
| CSN [A] | 101 | 5   | 50  | 3.6   | 0.42  | 0.36 |
| CSN [B] | 101 | 5   | 2.5 | 3.9   | 0.22  | 0.37 |
| GMO     | 107 | -   | -   | 5.1   | 0.54  | 0.35 |
