# Predicting Relevant Empty Spots In Social Interaction Yoshiharu Maeno · **Yukio Ohsawa**

Received: August 15, 2007 c **2006 Springer Science + Business Media, Inc.**
Abstract **An empty spot refers to an empty hard-to-fill space which can be found in the records of the**
social interaction, and is the clue to the persons in the underlying social network who do not appear in the records. This contribution addresses a problem to predict relevant empty spots in social interaction.

Homogeneous and inhomogeneous networks are studied as a model underlying the social interaction. A heuristic predictor function method is presented as a new method to address the problem. Simulation experiment is demonstrated over a homogeneous network. A test data set in the form of market baskets is generated from the simulated communication. Precision to predict the empty spots is calculated to demonstrate the performance of the presented method.

Key words **Communication, Empty spot, Predictor function, Social interaction, Social network**

## 1 Problem - Empty Spot

The activity of an organization is often under the influence of hidden **but relevant persons.**
The activity refers to decision-making and action-taking. In this contribution, the word **hidden**
means unobserved (unobservable) or invisible by the method used in **the observation, rather** than anonymous. The invisibility of the hidden persons is caused from **the limited capability** of the observation method, or from the limited prior understanding **of the targets to observe.** The organization may be a family, school, company, community, society etc.

For example, a financially supporting conspirator, who provides commanders with money, communication means, or weapons, is often hidden behind terrorism **attacks. Commanders**
would appear one after another if such a conspirator were not detected and arrested. It is, therefore, critical to predict the presence of such hidden but relevant persons from the observed records on the social interactions of an organization. Based on the prediction, we can invent a scenario for proactive investigation. The scenario turns the threat of disasters from the terrorism attacks into the opportunity to discover and destroy the hidden conspirator's social network supporting terrorism.

We define the above problem more specifically with three ideas. They are **social interaction**,
social network, and **empty spot**.