Figure 5 shows the evaluated precision p(mret**) for three trial cases. The top graph is the**
case when nodes around the node [a] are the hidden nodes. The middle and bottom graphs are for the node [b] and [c]. The horizontal axis is the number of the retrieved baskets (mret).

The order of the retrieved baskets is according to the largeness of the value which the predictor function outputs. Precision is very good when we try to predict the **baskets in case of the nodes** [b] and [c]. They occupy a unique position in terms of a global network topology (impartiality and efficiency in communication). The predictor function is suitable to **discover the hidden** nodes and related links.

On the other hand, precision degrades more steeply as mret **increases in case of the node**
[a]. The results indicate that the method can provide relevant information on the nodes which are hidden but relevant globally in a homogeneous network even if their local characteristics look similar. The nodes included in the retrieved baskets are likely to be **the gateway nodes to** the hidden nodes. From this information, we may be able to make a detailed investigation plan from the gateway persons toward the hidden persons.

## 6 Concluding Remark

This contribution presented a heuristic predictor function method **which is suitable to predict relevant empty spots in social interaction. The empty spot refers to an empty hard-to-fill**
space which can be found in the records of the social interaction. It is the clue to the persons in the underlying social network who do not appear in the records. Simulation experiment was demonstrated. This contribution, in particular, focused on the social interaction in homogeneous networks, where we believe that the problem to predict **the empty spots is more**
difficult than that in inhomogeneous networks[12]**. A test data set in the form of market baskets**
was generated from the simulated communication patterns. The baskets related to the hidden persons could be predicted by the value of the predictor function accurately.

The idea of relevant empty spots in social interaction can be generalized to hidden but relevant items working in a complex interacting system. We are seeking the possibility where something very new or just emerging is recognized, as well as the possibility where something hidden spatially is discovered. Y. Maeno et al. studied application to creative thinking[13]**. An**
experiment was carried out to see if we can invent a new technical idea from existing technical expertise forest (for example, patent document database or scientific article database). Texts of the patent documents for production machinery were analyzed morphologically and clustered into individual technical expertise. Sensor technology, conveyer **system or marking device are** example clusters. Participants were engineers and marketing specialists of a manufacturing company. They discussed about the identity of a new technical means (an empty spot) locating near the clusters. A few interesting and practical ideas were invented. Y. Maeno **et al.**
also studied application to designing catalyst personality fostering mutual understanding and communication among groups indicating opposing preference**[11]**.

We are combining these experiences in many application fields into a new **method named**
human-interactive annealing[10]**. It is designed to induce discovery from the difference between**
the individual human's prior understanding of the problem, and the computer's analysis and visualization of the observed data on the problem. Predicting relevant empty spots in social interaction is important in crime investingation, organization design, **business engineering, research and development. The method is expected to exploit many unobserved aspects of the**
social problems.