At first, the nodes in the observation are clustered into groups based on the inter-node distance. The distance (or closeness) are defined according to the co-occurrence frequency between the nodes. Occurrence frequency of a node F(ni**) is defined by Equation (5) using a**
Boolean function B(s) for a proposition s **in Equation (6).**

$$F(n_{i})\equiv\sum_{j=0}^{|b|-1}B(n_{i}\in b_{j}).$$  $$B(s)=\left\{\begin{array}{ll}1&\mbox{if$s$is TRUE}\\ 0&\mbox{otherwise}\end{array}\right..$$  $\bullet$
$$\left(5\right)$$
$$(6)$$

The frequency is the number of the baskets where ni **appears. The frequency is increased**
by 1 when ni appears once or more in a single basket. We use Jaccard's coefficient **defined**
by Equation (7) as a measure of the co-occurrence. Jaccard's coefficient is used widely in link discovery, web mining, or text processing[15]**. Co-occurrence frequency or dependence coefficient**
may also be used instead of Jaccard's coefficient.

$$J(n_{i},n_{j})\equiv{\frac{F(n_{i}\cap n_{j})}{F(n_{i}\cup n_{j})}}.$$
$$\left(7\right)$$
$$(8)$$

. (7)
Equation (7) is converted into Equations (8) using Equation (5).

$$J(n_{i},n_{j})={\frac{\sum_{k=0}^{|b|-1}B((n_{i}\in b_{k})\land(n_{j}\in b_{k}))}{\sum_{k=0}^{|b|-1}B((n_{i}\in b_{k})\lor(n_{j}\in b_{k}))}}.$$
. (8)
We employ k-medoid clustering algorithm[6] **because the amount of necessary calculation is**
small. It is simple and efficient. It is an EM (expectation-maximization) algorithm similar to k-means algorithm for numerical data. A medoid node nmed(j)**is a node locating most centrally**
within a cluster cj (0 ≤ j ≤ |c|−**1). They are initially selected at random. Other** |n|−|c| **nodes**
are classified into the clusters based on the closeness to the medoids. The number of clusters is denoted by |c|**. Then, a new medoid is selected within the individual cluster so that the sum**
of closeness from nodes within the cluster to the modoid is maximal. The sum of closeness
(M(cj ) within cj ) is evaluated by Equation (9). Iteration of updating the medoid n**med(**j)in the cluster to maximize M(cj**) is carried out until the medoids converge. The resulting clusters**
are denoted by cj . Self-organizing map[6] **and other unsupervised learning techniques are the**
alternatives.

$$M(c_{j})\equiv\sum_{(n_{i}\in c_{j})\land(n_{i}\neq n_{\mathrm{med}(j)})}J(n_{\mathrm{med}(j)},n_{i}).$$
$$(9)$$

J(nmed(j), ni). (9)
Then, the predictor function W(bi|D**) in Equation (10) is used to evaluate the likeliness of**
the individual baskets bi **as a candidate which should have included empty spots. The empty**
spots arise from the hidden participants to the basket, which is the **origin of attraction in the**
empty spots among clusters. The baskets ranked more highly are retrieved by the baskets.

$$W(b_{i}|D)\equiv\frac{1}{|c|}\sum_{j=0}^{|c|-1}\operatorname*{max}_{n_{k}\in c_{j}}\frac{B(n_{k}\in b_{i})}{\sum_{l}B(n_{k}\in b_{l})}.$$
$$(10)$$

Equation (10) is converted into a simpler formula (Equation (11)) using Equation (5).