# Translating Owl And Semantic Web Rules Into Prolog: Moving Toward Description Logic Programs

Ken Samuel1, Leo Obrst1, Suzette Stoutenberg2, Karen Fox2, Paul Franklin2, Adrian Johnson2, Ken Laskey1, Deborah Nichols1, Steve Lopez2, Jason Peterson2 
{samuel, lobrst, suzette, kfox, pfranklin, abjohnson, klaskey, dlnichols, slopez, jasonp}@mitre.org The MITRE Corporation 1 7525 Colshire Drive, McLean, VA 22102-7508 2 1155 Academy Park Loop, Colorado Springs, CO 80910-3716 Submitted 12 May 2006; revised 24 Sep 2007; accepted 18 October 2007 Abstract. We are researching the interaction between the rule and the ontology layers of the Semantic Web, by comparing two options: 1) using OWL and its rule extension SWRL to develop an integrated ontology/rule language, and 2) layering rules on top of an ontology with RuleML and OWL. Toward this end, we are developing the SWORIER system, which enables efficient automated reasoning on ontologies and rules, by translating all of them into Prolog and adding a set of general rules that properly capture the semantics of OWL. We have also enabled the user to make dynamic changes on the fly, at run time. This work addresses several of the concerns expressed in previous work, such as negation, complementary classes, disjunctive heads, and cardinality, and it discusses alternative approaches for dealing with inconsistencies in the knowledge base. In addition, for efficiency, we implemented techniques called extensionalization, avoiding reanalysis, and code minimization.

Keywords: Semantic Web, logic programming, knowledge compilation, ontologies, rules 

## 1. Introduction

 The wedding of Semantic Web technology and Logic Programming has created a new technical paradigm called *description logic programming*. Recently, researchers have begun focusing on the question of how to utilize logical rules from a particular domain in order to improve the Semantic Web (Bechhofer *et al.* 2004; Hirtle *et al.* 2004; Horrocks *et al.* 2004). It is well established that the knowledge development language and the knowledge runtime language may not be the same, so the former should be transformed to the latter for greater efficiency at run time (Cadoli & Donini 1997; Darwiche & Marquis 2001). 

 We have developed SWORIER (Semantic Web Ontologies and Rules for Interoperability with Efficient Reasoning), which is a system that uses Logic Programming to reason about and answer queries about ontologies and rules (Grosof *et al.* 2003; Hitzler *et al.* 2005; Volz *et al.* 2003). OWL (Web Ontology Language) ontologies (Bechhofer *et al.* 2004), along with rules in the Semantic Web Rule Language (SWRL) (Horrocks *et al.* 2004) or the Rule Markup Language 
(RuleML) (Hirtle *et al.* 2004) are all translated into Prolog using XSLTs (Extensible Stylesheet Language Transformations). In addition, we have written a set of *General Rules* in Prolog in order to enforce the semantics of OWL primitives. To do this, it was necessary to address a number of issues related to negation, the open world assumption, complementary and disjoint classes, disjunctive conclusions, enumerated classes, equivalent individuals, error messages, existential quantification, cardinality constraints, duplicate facts, cyclical hierarchies, and anonymous classes. Recent work has suggested that some of these problems are unsolvable (Volz et al. 2003), but we believe we have found solutions for them. 

1