 We propose changing the subclass transitive closure rules (Table 3a) into the rules in Table 13b. The idea is to stop the cycle when it reaches the beginning again, which occurs when the two parameters of isSubClassOf are equal. For this purpose, we create a new predicate is_sub_class_of_but_not_equal_to that includes all of the subclass relations, except for the reflexive ones. (The first rule catches them.) Note that we use the technique discussed in Section 4.9, by including isclass predicates to insure that the variables are bound before running any not tests on them. 

b.

![0_image_1.png](0_image_1.png)

| Table 13. Cyclic Hierarchies                                                                                                                                                                                                                                                                                                                                                                                            |
|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| issubclassof(armedForce, coalition).  issubclassof(coalition, politicalGroup).  issubclassof(politicalGroup, armedForce).  isSubClassOf(C, C).  isSubClassOf(C, D) :- is_sub_class_of_but_not_equal_to(C, D). is_sub_class_of_but_not_equal_to(C, D) :- issubclassof(C, D). is_sub_class_of_but_not_equal_to(C, E) :-   isclass(C), isclass(E), not(C=E),   issubclassof(C, D), is_sub_class_of_but_not_equal_to(D, E). |

![0_image_0.png](0_image_0.png)

## 4.11. Anonymous Classes

 OWL can define classes called anonymous classes without actually naming them. Table 14a has an example of an anonymous class, and Table 14b has our suggestion of how to translate it. An anonymous class, unnamedClass(hasCombatIntent, friendly-Intent), is generated like anonymous individuals that were presented in Section 4.7. 

![0_image_3.png](0_image_3.png)

| <owl:Class>   <hasCombatIntent rdf:resource="#friendlyIntent"/> </owl:Class>  hasallvaluesofpropertyfrom(   unnamedClass(hasCombatIntent, friendlyIntent),   hasCombatIntent,   friendlyIntent).   |
|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|

![0_image_2.png](0_image_2.png)

hasallvaluesofpropertyfrom( 

 unnamedClass(hasCombatIntent, friendlyIntent), 

 hasCombatIntent, 

 friendlyIntent). 

 

## 5. Dynamic Changes

 Another useful capability is to change the knowledge base at run time. For example, in our convoy task, intelligence reports can come in at any time during a scenario, and we want SWORIER to be able to incorporate the new information into the knowledge base. This must be done within a few seconds. So, we have enabled SWORIER to accommodate *dynamic changes* of facts, adding or removing facts at run time. (We have not yet tried dynamically changing classes, properties, or rules.) Unfortunately, dynamic assertions significantly decrease efficiency, because the Prolog compiler can no longer be used. It is not possible to assert or retract any facts with predicates that are compiled. This issue is addressed in Section 6.3. SWORIER is also capable of dynamically changing rules, but only in a restricted way. We require that all of the desired rule sets are available in advance. This can still be quite useful. For example, under low visibility conditions, different rules might be desired from the rules used with high visibility. Both rule sets can be developed in advance, and then SWORIER can generate a separate program for each case. These rules might be considered different policies or rules invoked by different contexts. At run time, when visibility is high, the user queries are submitted to the first program. But whenever visibility is lost, such as at the onset of a sandstorm, the two programs are swapped, and the user queries are sent to the second program. 