

![0_image_1.png](0_image_1.png)

![0_image_0.png](0_image_0.png)

b.

 This preprocessing technique enabled the system to work much faster, as shown in Table 15b. However, it still required 25.2 minutes to incorporate the same two dynamic changes as in the previous test, and to answer the two queries took 58 minutes. This is still unacceptably slow. In addition, the offline extensionalization process caused the AMZI Prolog application to crash, as shown in Table 17a. We presume that the computer ran out of memory. 

| Table 17. Extensionalization Time (offline)   |                   |                    |           |
|-----------------------------------------------|-------------------|--------------------|-----------|
| Avoiding Reanalysis                           | Code Minimization | Extensionalization |           |
| a.                                            | no                | no                 | CRASH     |
| b.                                            | yes               | no                 | 13 hours  |
| c.                                            | yes               | yes                | 6.5 hours |

## 6.2. Avoiding Reanalysis

 In the process of extensionalizing the code, it was very common to test a term several times with the same arguments. This unnecessary processing can be very slow. For example, given the code in Table 18, the system must test isSubClassOf(convoy, theaterobject) at least twice: Once when searching for all of the true isSubClassOf terms, and again when trying to prove isMemberOf(convoy1, theaterobject). 

Table 18. Reevaluating a Term ismemberof(convoy1, convoy). 

issubclassof(convoy, militaryunit). 

issubclassof(militaryunit, theaterobject). isSubClassOf(C, D) :- issubclassof(C, D). 

isSubClassOf(C, E) :- issubclassof(C, D), isSubClassOf(D, E).

isMemberOf(I, C) :- ismemberof(I, C). isMemberOf(I, D) :- isSubClassOf(C, D), isMemberOf(I, C).

 The proof of isSubClassOf(convoy, theaterobject) takes five steps.3 In general, a very slow test may be run several times. To avoid the reevaluation of a term, each time 3 1. isSubClassOf(convoy, theaterobject) :- 
 issubclassof(convoy, theaterobject). *(FAILS)* 2. isSubClassOf(convoy, theaterobject) :- 
 issubclassof(convoy, D), isSubClassOf(D, theaterobject).

 3. issubclassof(convoy, militaryunit). 4. isSubClassOf(militaryunit, theaterobject) :- 